/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import pl.allegro.tech.hermes.common.admin.AdminTool;
import pl.allegro.tech.hermes.common.admin.zookeeper.ZookeeperAdminTool;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.common.kafka.offset.SubscriptionOffsetChangeIndicator;
import pl.allegro.tech.hermes.common.message.undelivered.LastUndeliveredMessageReader;
import pl.allegro.tech.hermes.common.message.undelivered.ZookeeperLastUndeliveredMessageReader;
import pl.allegro.tech.hermes.domain.CredentialsRepository;
import pl.allegro.tech.hermes.domain.group.GroupRepository;
import pl.allegro.tech.hermes.domain.oauth.OAuthProviderRepository;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.domain.topic.preview.MessagePreviewRepository;
import pl.allegro.tech.hermes.domain.workload.constraints.WorkloadConstraintsRepository;
import pl.allegro.tech.hermes.infrastructure.dc.DatacenterNameProvider;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperCredentialsRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperMessagePreviewRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperOAuthProviderRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperSubscriptionOffsetChangeIndicator;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperSubscriptionRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperTopicRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperWorkloadConstraintsRepository;
import pl.allegro.tech.hermes.management.config.storage.ZookeeperGroupRepositoryFactory;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryManager;
import pl.allegro.tech.hermes.management.domain.detection.InactiveTopicsRepository;
import pl.allegro.tech.hermes.management.domain.readiness.DatacenterReadinessRepository;
import pl.allegro.tech.hermes.management.domain.retransmit.OfflineRetransmissionRepository;
import pl.allegro.tech.hermes.management.domain.subscription.consumergroup.ConsumerGroupToDeleteRepository;
import pl.allegro.tech.hermes.management.infrastructure.detection.ZookeeperInactiveTopicsRepository;
import pl.allegro.tech.hermes.management.infrastructure.readiness.ZookeeperDatacenterReadinessRepository;
import pl.allegro.tech.hermes.management.infrastructure.retransmit.ZookeeperOfflineRetransmissionRepository;
import pl.allegro.tech.hermes.management.infrastructure.subscription.consumergroup.ZookeeperConsumerGroupToDeleteRepository;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperClient;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperClientManager;

public class ZookeeperRepositoryManager
implements RepositoryManager {
    private final DatacenterNameProvider datacenterNameProvider;
    private final ObjectMapper mapper;
    private final ZookeeperPaths paths;
    private final ZookeeperClientManager clientManager;
    private final Map<Class<?>, Object> repositoryByType = new HashMap();
    private final Map<String, GroupRepository> groupRepositoriesByDc = new HashMap<String, GroupRepository>();
    private final Map<String, CredentialsRepository> credentialsRepositoriesByDc = new HashMap<String, CredentialsRepository>();
    private final Map<String, TopicRepository> topicRepositoriesByDc = new HashMap<String, TopicRepository>();
    private final Map<String, SubscriptionRepository> subscriptionRepositoriesByDc = new HashMap<String, SubscriptionRepository>();
    private final Map<String, OAuthProviderRepository> oAuthProviderRepositoriesByDc = new HashMap<String, OAuthProviderRepository>();
    private final Map<String, SubscriptionOffsetChangeIndicator> offsetChangeIndicatorsByDc = new HashMap<String, SubscriptionOffsetChangeIndicator>();
    private final Map<String, MessagePreviewRepository> messagePreviewRepositoriesByDc = new HashMap<String, MessagePreviewRepository>();
    private final Map<String, WorkloadConstraintsRepository> workloadConstraintsRepositoriesByDc = new HashMap<String, WorkloadConstraintsRepository>();
    private final Map<String, LastUndeliveredMessageReader> lastUndeliveredMessageReaderByDc = new HashMap<String, LastUndeliveredMessageReader>();
    private final Map<String, AdminTool> adminToolByDc = new HashMap<String, AdminTool>();
    private final Map<String, DatacenterReadinessRepository> readinessRepositoriesByDc = new HashMap<String, DatacenterReadinessRepository>();
    private final Map<String, OfflineRetransmissionRepository> offlineRetransmissionRepositoriesByDc = new HashMap<String, OfflineRetransmissionRepository>();
    private final Map<String, InactiveTopicsRepository> inactiveTopicsRepositoriesByDc = new HashMap<String, InactiveTopicsRepository>();
    private final Map<String, ConsumerGroupToDeleteRepository> consumerGroupCleanupRepositoryByDc = new HashMap<String, ConsumerGroupToDeleteRepository>();
    private final ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory;

    public ZookeeperRepositoryManager(ZookeeperClientManager clientManager, DatacenterNameProvider datacenterNameProvider, ObjectMapper mapper, ZookeeperPaths paths, ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory) {
        this.datacenterNameProvider = datacenterNameProvider;
        this.mapper = mapper;
        this.paths = paths;
        this.clientManager = clientManager;
        this.zookeeperGroupRepositoryFactory = zookeeperGroupRepositoryFactory;
        this.initRepositoryTypeMap();
    }

    public void start() {
        for (ZookeeperClient client : this.clientManager.getClients()) {
            String dcName = client.getDatacenterName();
            CuratorFramework zookeeper = client.getCuratorFramework();
            GroupRepository groupRepository = this.zookeeperGroupRepositoryFactory.create(zookeeper, this.mapper, this.paths);
            this.groupRepositoriesByDc.put(dcName, groupRepository);
            ZookeeperCredentialsRepository credentialsRepository = new ZookeeperCredentialsRepository(zookeeper, this.mapper, this.paths);
            this.credentialsRepositoriesByDc.put(dcName, (CredentialsRepository)credentialsRepository);
            ZookeeperTopicRepository topicRepository = new ZookeeperTopicRepository(zookeeper, this.mapper, this.paths, groupRepository);
            this.topicRepositoriesByDc.put(dcName, (TopicRepository)topicRepository);
            ZookeeperSubscriptionRepository subscriptionRepository = new ZookeeperSubscriptionRepository(zookeeper, this.mapper, this.paths, (TopicRepository)topicRepository);
            this.subscriptionRepositoriesByDc.put(dcName, (SubscriptionRepository)subscriptionRepository);
            ZookeeperOAuthProviderRepository oAuthProviderRepository = new ZookeeperOAuthProviderRepository(zookeeper, this.mapper, this.paths);
            this.oAuthProviderRepositoriesByDc.put(dcName, (OAuthProviderRepository)oAuthProviderRepository);
            ZookeeperSubscriptionOffsetChangeIndicator offsetChangeIndicator = new ZookeeperSubscriptionOffsetChangeIndicator(zookeeper, this.paths, (SubscriptionRepository)subscriptionRepository);
            this.offsetChangeIndicatorsByDc.put(dcName, (SubscriptionOffsetChangeIndicator)offsetChangeIndicator);
            ZookeeperMessagePreviewRepository messagePreviewRepository = new ZookeeperMessagePreviewRepository(zookeeper, this.mapper, this.paths);
            this.messagePreviewRepositoriesByDc.put(dcName, (MessagePreviewRepository)messagePreviewRepository);
            ZookeeperWorkloadConstraintsRepository workloadConstraintsRepository = new ZookeeperWorkloadConstraintsRepository(zookeeper, this.mapper, this.paths);
            this.workloadConstraintsRepositoriesByDc.put(dcName, (WorkloadConstraintsRepository)workloadConstraintsRepository);
            ZookeeperLastUndeliveredMessageReader lastUndeliveredMessageReader = new ZookeeperLastUndeliveredMessageReader(zookeeper, this.paths, this.mapper);
            this.lastUndeliveredMessageReaderByDc.put(dcName, (LastUndeliveredMessageReader)lastUndeliveredMessageReader);
            ZookeeperAdminTool adminTool = new ZookeeperAdminTool(this.paths, client.getCuratorFramework(), this.mapper);
            this.adminToolByDc.put(dcName, (AdminTool)adminTool);
            ZookeeperDatacenterReadinessRepository readinessRepository = new ZookeeperDatacenterReadinessRepository(zookeeper, this.mapper, this.paths);
            this.readinessRepositoriesByDc.put(dcName, readinessRepository);
            ZookeeperOfflineRetransmissionRepository offlineRetransmissionRepository = new ZookeeperOfflineRetransmissionRepository(zookeeper, this.mapper, this.paths);
            this.offlineRetransmissionRepositoriesByDc.put(dcName, offlineRetransmissionRepository);
            ZookeeperInactiveTopicsRepository inactiveTopicsRepository = new ZookeeperInactiveTopicsRepository(zookeeper, this.mapper, this.paths);
            this.inactiveTopicsRepositoriesByDc.put(dcName, inactiveTopicsRepository);
            ZookeeperConsumerGroupToDeleteRepository consumerGroupCleanupRepository = new ZookeeperConsumerGroupToDeleteRepository(zookeeper, this.mapper, this.paths);
            this.consumerGroupCleanupRepositoryByDc.put(dcName, consumerGroupCleanupRepository);
        }
    }

    @Override
    public <T> DatacenterBoundRepositoryHolder<T> getLocalRepository(Class<T> repositoryType) {
        String dcName = this.datacenterNameProvider.getDatacenterName();
        T repository = this.getRepositoriesByType(repositoryType).get(dcName);
        if (repository == null) {
            throw new InternalProcessingException("Failed to find '" + repositoryType.getSimpleName() + "' bound with DC '" + dcName + "'.");
        }
        return new DatacenterBoundRepositoryHolder<T>(repository, dcName);
    }

    @Override
    public <T> List<DatacenterBoundRepositoryHolder<T>> getRepositories(Class<T> repositoryType) {
        return this.getRepositoriesByType(repositoryType).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> new DatacenterBoundRepositoryHolder(entry.getValue(), (String)entry.getKey())).collect(Collectors.toList());
    }

    public <T> Map<String, T> getRepositoriesByType(Class<T> type) {
        Object repository = this.repositoryByType.get(type);
        if (repository == null) {
            throw new InternalProcessingException("Could not provide repository of type: " + type.getName());
        }
        return (Map)repository;
    }

    private void initRepositoryTypeMap() {
        this.repositoryByType.put(GroupRepository.class, this.groupRepositoriesByDc);
        this.repositoryByType.put(CredentialsRepository.class, this.credentialsRepositoriesByDc);
        this.repositoryByType.put(TopicRepository.class, this.topicRepositoriesByDc);
        this.repositoryByType.put(SubscriptionRepository.class, this.subscriptionRepositoriesByDc);
        this.repositoryByType.put(OAuthProviderRepository.class, this.oAuthProviderRepositoriesByDc);
        this.repositoryByType.put(SubscriptionOffsetChangeIndicator.class, this.offsetChangeIndicatorsByDc);
        this.repositoryByType.put(MessagePreviewRepository.class, this.messagePreviewRepositoriesByDc);
        this.repositoryByType.put(WorkloadConstraintsRepository.class, this.workloadConstraintsRepositoriesByDc);
        this.repositoryByType.put(LastUndeliveredMessageReader.class, this.lastUndeliveredMessageReaderByDc);
        this.repositoryByType.put(AdminTool.class, this.adminToolByDc);
        this.repositoryByType.put(DatacenterReadinessRepository.class, this.readinessRepositoriesByDc);
        this.repositoryByType.put(OfflineRetransmissionRepository.class, this.offlineRetransmissionRepositoriesByDc);
        this.repositoryByType.put(InactiveTopicsRepository.class, this.inactiveTopicsRepositoriesByDc);
        this.repositoryByType.put(ConsumerGroupToDeleteRepository.class, this.consumerGroupCleanupRepositoryByDc);
    }
}

