/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.graphite;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import pl.allegro.tech.hermes.api.MetricDecimalValue;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteMetrics;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteResponse;

public class RestTemplateGraphiteClient
implements GraphiteClient {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateGraphiteClient.class);
    private static final ParameterizedTypeReference<List<GraphiteResponse>> GRAPHITE_RESPONSE_TYPE = new ParameterizedTypeReference<List<GraphiteResponse>>(){};
    private static final String DEFAULT_VALUE = "0.0";
    private static final String TARGET_PARAM = "target";
    private final URI graphiteUri;
    private final RestTemplate restTemplate;

    public RestTemplateGraphiteClient(RestTemplate restTemplate, URI graphiteUri) {
        this.restTemplate = restTemplate;
        this.graphiteUri = graphiteUri;
    }

    @Override
    public GraphiteMetrics readMetrics(String ... metricPaths) {
        try {
            GraphiteMetrics response = new GraphiteMetrics();
            this.queryGraphite(metricPaths).stream().forEach(metric -> response.addMetricValue(metric.getTarget(), this.getFirstValue((GraphiteResponse)metric)));
            return response;
        }
        catch (Exception exception) {
            logger.warn("Unable to read from Graphite: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)exception));
            return GraphiteMetrics.unavailable(metricPaths);
        }
    }

    private MetricDecimalValue getFirstValue(GraphiteResponse graphiteResponse) {
        Preconditions.checkArgument((boolean)this.hasDatapoints(graphiteResponse), (Object)"Graphite format changed. Reexamine implementation.");
        String firstNotNullValue = DEFAULT_VALUE;
        for (List<String> datapoint : graphiteResponse.getDatapoints()) {
            if (!this.datapointValid(datapoint)) continue;
            firstNotNullValue = datapoint.get(0);
            break;
        }
        return MetricDecimalValue.of((String)firstNotNullValue);
    }

    private boolean datapointValid(List<String> value) {
        return !value.isEmpty() && !Strings.isNullOrEmpty((String)value.get(0)) && !"null".equals(value.get(0));
    }

    private boolean hasDatapoints(GraphiteResponse graphiteResponse) {
        return !graphiteResponse.getDatapoints().isEmpty() && !graphiteResponse.getDatapoints().get(0).isEmpty();
    }

    private List<GraphiteResponse> queryGraphite(String ... queries) throws UnsupportedEncodingException {
        UriBuilder builder = UriBuilder.fromUri((URI)this.graphiteUri).path("render").queryParam("from", new Object[]{"-5minutes"}).queryParam("until", new Object[]{"-1minutes"}).queryParam("format", new Object[]{"json"});
        for (String query : queries) {
            builder.queryParam(TARGET_PARAM, new Object[]{query});
        }
        ResponseEntity response = this.restTemplate.exchange(builder.build(new Object[0]), HttpMethod.GET, HttpEntity.EMPTY, GRAPHITE_RESPONSE_TYPE);
        return (List)response.getBody();
    }
}

