/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Group;
import pl.allegro.tech.hermes.api.Query;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionNameWithMetrics;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicNameWithMetrics;
import pl.allegro.tech.hermes.management.domain.group.GroupService;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionService;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;

@Path(value="query")
@Component
public class QueryEndpoint {
    private final SubscriptionService subscriptionService;
    private final TopicService topicService;
    private final GroupService groupService;

    @Autowired
    public QueryEndpoint(SubscriptionService subscriptionService, TopicService topicService, GroupService groupService) {
        this.subscriptionService = subscriptionService;
        this.topicService = topicService;
        this.groupService = groupService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/groups")
    public List<Group> queryGroups(Query<Group> query) {
        return this.groupService.queryGroup(query);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/topics")
    public List<Topic> queryTopics(Query<Topic> query) {
        return this.topicService.queryTopic(query);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/subscriptions")
    public List<Subscription> querySubscriptions(Query<Subscription> query) {
        return this.subscriptionService.querySubscription(query);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/topics/metrics")
    public List<TopicNameWithMetrics> queryTopicsMetrics(Query<TopicNameWithMetrics> query) {
        return this.topicService.queryTopicsMetrics(query);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="subscriptions/metrics")
    public List<SubscriptionNameWithMetrics> querySubscriptionsMetrics(Query<SubscriptionNameWithMetrics> query) {
        return this.subscriptionService.querySubscriptionsMetrics(query);
    }
}

