/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;

public class ZookeeperClient {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperClient.class);
    private final CuratorFramework curatorFramework;
    private final String datacenterName;

    ZookeeperClient(CuratorFramework curatorFramework, String datacenterName) {
        this.curatorFramework = curatorFramework;
        this.datacenterName = datacenterName;
    }

    public CuratorFramework getCuratorFramework() {
        return this.curatorFramework;
    }

    public String getDatacenterName() {
        return this.datacenterName;
    }

    public void ensurePathExists(String path) {
        try {
            if (this.curatorFramework.checkExists().forPath(path) == null) {
                logger.info("Creating path: {} in Zookeeper: {}", (Object)path, (Object)this.datacenterName);
                this.curatorFramework.create().creatingParentsIfNeeded().forPath(path);
            }
        }
        catch (Exception e) {
            logger.error("Error when creating path: {} in Zookeeper: {}", new Object[]{path, this.datacenterName, e});
            throw new InternalProcessingException("Could not ensure existence of path: " + path);
        }
    }

    public void ensureEphemeralNodeExists(String path) {
        try {
            if (this.curatorFramework.checkExists().forPath(path) == null) {
                ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(path);
            }
        }
        catch (Exception e) {
            throw new InternalProcessingException("Could not ensure existence of path: " + path);
        }
    }
}

