/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.management.domain.mode.ModeService;

@Component
@Path(value="/mode")
@Api(value="/mode", description="Operations on management mode")
public class ModeEndpoint {
    private final ModeService modeService;

    public ModeEndpoint(ModeService modeService) {
        this.modeService = modeService;
    }

    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get management mode", response=String.class, httpMethod="GET")
    public String getMode() {
        return this.modeService.getMode().toString();
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Set management mode", response=String.class, httpMethod="POST")
    @RolesAllowed(value={"admin"})
    public Response setMode(@QueryParam(value="mode") String mode) {
        if (mode == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        switch (mode) {
            case "readWrite": {
                this.modeService.setModeByAdmin(ModeService.ManagementMode.READ_WRITE);
                break;
            }
            case "readOnly": 
            case "readOnlyAdmin": {
                this.modeService.setModeByAdmin(ModeService.ManagementMode.READ_ONLY_ADMIN);
                break;
            }
            default: {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

