/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.dc;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundQueryResult;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.ExceptionWrapper;
import pl.allegro.tech.hermes.management.domain.dc.QueryCommand;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryManager;

public class MultiDatacenterRepositoryQueryExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MultiDatacenterRepositoryQueryExecutor.class);
    private final RepositoryManager repositoryManager;

    public MultiDatacenterRepositoryQueryExecutor(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public <T, K> List<DatacenterBoundQueryResult<T>> execute(QueryCommand<T, K> command) {
        List<DatacenterBoundRepositoryHolder<K>> repoHolders = this.repositoryManager.getRepositories(command.getRepositoryType());
        return repoHolders.stream().map(holder -> {
            try {
                return new DatacenterBoundQueryResult(command.query((DatacenterBoundRepositoryHolder)holder), holder.getDatacenterName());
            }
            catch (Exception e) {
                logger.warn("Execute failed with an error", (Throwable)e);
                throw ExceptionWrapper.wrapInInternalProcessingExceptionIfNeeded(e, command.toString(), holder.getDatacenterName());
            }
        }).collect(Collectors.toList());
    }
}

