/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.readiness;

import pl.allegro.tech.hermes.api.DatacenterReadiness;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;
import pl.allegro.tech.hermes.management.domain.readiness.ReadinessRepository;

public class SetReadinessCommand
extends RepositoryCommand<ReadinessRepository> {
    private final DatacenterReadiness readiness;

    public SetReadinessCommand(DatacenterReadiness readiness) {
        this.readiness = readiness;
    }

    @Override
    public void backup(DatacenterBoundRepositoryHolder<ReadinessRepository> holder) {
    }

    @Override
    public void execute(DatacenterBoundRepositoryHolder<ReadinessRepository> holder) {
        if (holder.getDatacenterName().equals(this.readiness.getDatacenter())) {
            holder.getRepository().setReadiness(this.isReady());
        }
    }

    private boolean isReady() {
        switch (this.readiness.getStatus()) {
            case READY: {
                return true;
            }
            case NOT_READY: {
                return false;
            }
        }
        throw new InternalProcessingException("Invalid readiness status: " + this.readiness.getStatus());
    }

    @Override
    public void rollback(DatacenterBoundRepositoryHolder<ReadinessRepository> holder) {
    }

    @Override
    public Class<ReadinessRepository> getRepositoryType() {
        return ReadinessRepository.class;
    }

    public String toString() {
        return "SetReadinessCommand(" + this.readiness.toString() + ")";
    }
}

