/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import pl.allegro.tech.hermes.api.SubscriptionHealthProblem;
import pl.allegro.tech.hermes.api.UnhealthySubscription;

@Provider
@Produces(value={"text/plain"})
public class UnhealthySubscriptionListPlainTextBodyWriter
implements MessageBodyWriter<List<UnhealthySubscription>> {
    private static String toPlainText(UnhealthySubscription unhealthySubscription) {
        String problemDescriptions = unhealthySubscription.getProblems().stream().map(SubscriptionHealthProblem::getDescription).collect(Collectors.joining("; "));
        return unhealthySubscription.getName() + " - " + problemDescriptions;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (List.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type[] actualTypeArgs = parameterizedType.getActualTypeArguments();
            return actualTypeArgs.length == 1 && actualTypeArgs[0].equals(UnhealthySubscription.class);
        }
        return false;
    }

    public long getSize(List<UnhealthySubscription> unhealthySubscriptionList, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(List<UnhealthySubscription> unhealthySubscriptionList, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String body = unhealthySubscriptionList.stream().map(UnhealthySubscriptionListPlainTextBodyWriter::toPlainText).collect(Collectors.joining("\r\n"));
        entityStream.write(body.getBytes());
    }
}

