/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import org.javers.core.Javers;
import org.javers.core.diff.Diff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.management.domain.Auditor;
import pl.allegro.tech.hermes.management.infrastructure.audit.AuditEvent;
import pl.allegro.tech.hermes.management.infrastructure.audit.AuditEventType;

public class EventAuditor
implements Auditor {
    private static final Logger logger = LoggerFactory.getLogger(EventAuditor.class);
    private final Javers javers;
    private final RestTemplate restTemplate;
    private final String eventDestination;
    private final ObjectMapper objectMapper;

    public EventAuditor(Javers javers, RestTemplate restTemplate, String eventDestination, ObjectMapper objectMapper) {
        this.javers = (Javers)Preconditions.checkNotNull((Object)javers);
        this.restTemplate = (RestTemplate)Preconditions.checkNotNull((Object)restTemplate);
        this.eventDestination = eventDestination;
        this.objectMapper = objectMapper;
    }

    @Override
    public void beforeObjectCreation(String username, Object createdObject) {
        this.ignoringExceptions(() -> {
            String createdObjectToString = this.objectMapper.writeValueAsString(createdObject);
            AuditEvent event = new AuditEvent(AuditEventType.BEFORE_CREATION, createdObjectToString, createdObject.getClass().getSimpleName(), createdObject.toString(), username);
            this.restTemplate.postForObject(this.eventDestination, (Object)event, Void.class, new Object[0]);
        });
    }

    @Override
    public void beforeObjectRemoval(String username, String removedObjectType, String removedObjectName) {
        this.ignoringExceptions(() -> {
            AuditEvent event = new AuditEvent(AuditEventType.BEFORE_REMOVAL, removedObjectName, removedObjectType, removedObjectName, username);
            this.restTemplate.postForObject(this.eventDestination, (Object)event, Void.class, new Object[0]);
        });
    }

    @Override
    public void beforeObjectUpdate(String username, String objectClassName, Object objectName, PatchData patchData) {
        this.ignoringExceptions(() -> {
            String patchDataToString = this.objectMapper.writeValueAsString((Object)patchData);
            AuditEvent event = new AuditEvent(AuditEventType.BEFORE_UPDATE, patchDataToString, patchData.getClass().getSimpleName(), objectName.toString(), username);
            this.restTemplate.postForObject(this.eventDestination, (Object)event, Void.class, new Object[0]);
        });
    }

    @Override
    public void objectCreated(String username, Object createdObject) {
        this.ignoringExceptions(() -> {
            String createdObjectToString = this.objectMapper.writeValueAsString(createdObject);
            AuditEvent event = new AuditEvent(AuditEventType.CREATED, createdObjectToString, createdObject.getClass().getSimpleName(), createdObject.toString(), username);
            this.restTemplate.postForObject(this.eventDestination, (Object)event, Void.class, new Object[0]);
        });
    }

    @Override
    public void objectRemoved(String username, Object removedObject) {
        this.ignoringExceptions(() -> {
            String removedObjectToString = this.objectMapper.writeValueAsString(removedObject);
            AuditEvent event = new AuditEvent(AuditEventType.REMOVED, removedObjectToString, removedObject.getClass().getSimpleName(), removedObject.toString(), username);
            this.restTemplate.postForObject(this.eventDestination, (Object)event, Void.class, new Object[0]);
        });
    }

    @Override
    public void objectUpdated(String username, Object oldObject, Object newObject) {
        this.ignoringExceptions(() -> {
            Diff diff = this.javers.compare(oldObject, newObject);
            AuditEvent event = new AuditEvent(AuditEventType.UPDATED, diff.toString(), oldObject.getClass().getSimpleName(), oldObject.toString(), username);
            this.restTemplate.postForObject(this.eventDestination, (Object)event, Void.class, new Object[0]);
        });
    }

    private void ignoringExceptions(Wrapped wrapped) {
        try {
            wrapped.execute();
        }
        catch (Exception e) {
            logger.info("Audit event emission failed.", (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface Wrapped {
        public void execute() throws Exception;
    }
}

