/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import pl.allegro.tech.hermes.management.config.MicrometerRegistryProperties;
import pl.allegro.tech.hermes.management.config.PrometheusConfigAdapter;
import pl.allegro.tech.hermes.management.config.PrometheusProperties;

@EnableConfigurationProperties(value={MicrometerRegistryProperties.class})
public class PrometheusConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PrometheusMeterRegistry micrometerRegistry(MicrometerRegistryProperties properties, PrometheusConfig prometheusConfig) {
        return new PrometheusMeterRegistryFactory(properties, prometheusConfig, "hermes-management").provide();
    }

    @Bean
    @ConditionalOnMissingBean
    PrometheusConfig prometheusConfig(PrometheusProperties properties) {
        return new PrometheusConfigAdapter(properties);
    }

    static class PrometheusMeterRegistryFactory {
        private final MicrometerRegistryProperties parameters;
        private final PrometheusConfig prometheusConfig;
        private final String prefix;

        PrometheusMeterRegistryFactory(MicrometerRegistryProperties properties, PrometheusConfig prometheusConfig, String prefix) {
            this.parameters = properties;
            this.prometheusConfig = prometheusConfig;
            this.prefix = prefix + "_";
        }

        PrometheusMeterRegistry provide() {
            PrometheusMeterRegistry meterRegistry = new PrometheusMeterRegistry(this.prometheusConfig);
            this.applyFilters(meterRegistry);
            return meterRegistry;
        }

        void applyFilters(PrometheusMeterRegistry meterRegistry) {
            meterRegistry.config().meterFilter(new MeterFilter(){

                public Meter.Id map(Meter.Id id) {
                    return id.withName(prefix + id.getName());
                }

                public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
                    return DistributionStatisticConfig.builder().percentiles(parameters.getPercentiles().stream().mapToDouble(Double::doubleValue).toArray()).build().merge(config);
                }
            });
        }
    }
}

