/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.DatacenterReadiness;
import pl.allegro.tech.hermes.api.Readiness;
import pl.allegro.tech.hermes.management.domain.readiness.ReadinessService;

@Path(value="readiness/datacenters")
@Component
public class ReadinessEndpoint {
    private final ReadinessService readinessService;

    public ReadinessEndpoint(ReadinessService readinessService) {
        this.readinessService = readinessService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @Path(value="/{datacenter}")
    public Response setReadiness(@PathParam(value="datacenter") String datacenter, Readiness readiness) {
        this.readinessService.setReady(new DatacenterReadiness(datacenter, readiness.isReady() ? DatacenterReadiness.ReadinessStatus.READY : DatacenterReadiness.ReadinessStatus.NOT_READY));
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    public List<DatacenterReadiness> getReadiness() {
        return this.readinessService.getDatacentersReadinesses();
    }
}

