/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import io.swagger.annotations.ApiOperation;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import pl.allegro.tech.hermes.api.RawSchema;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.api.auth.HermesSecurityAwareRequestUser;
import pl.allegro.tech.hermes.management.domain.auth.RequestUser;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.management.domain.topic.schema.SchemaService;
import pl.allegro.tech.hermes.schema.SchemaId;
import pl.allegro.tech.hermes.schema.SchemaVersion;

@Path(value="topics/{topicName}/schema")
public class SchemaEndpoint {
    private final SchemaService schemaService;
    private final TopicService topicService;

    @Autowired
    public SchemaEndpoint(SchemaService schemaService, TopicService topicService) {
        this.schemaService = schemaService;
        this.topicService = topicService;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get schema", httpMethod="GET")
    public Response get(@PathParam(value="topicName") String qualifiedTopicName) {
        Optional<RawSchema> rawSchema = this.schemaService.getSchema(qualifiedTopicName);
        return rawSchema.map(RawSchema::value).map(v -> Response.ok((Object)v).build()).orElse(Response.noContent().build());
    }

    @GET
    @Path(value="versions/{version}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get schema", httpMethod="GET")
    public Response getByVersion(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="version") int version) {
        Optional<RawSchema> rawSchema = this.schemaService.getSchema(qualifiedTopicName, SchemaVersion.valueOf((int)version));
        return rawSchema.map(RawSchema::value).map(v -> Response.ok((Object)v).build()).orElse(Response.noContent().build());
    }

    @GET
    @Path(value="ids/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get schema", httpMethod="GET")
    public Response getById(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="id") int id) {
        Optional<RawSchema> rawSchema = this.schemaService.getSchema(qualifiedTopicName, SchemaId.valueOf((int)id));
        return rawSchema.map(RawSchema::value).map(v -> Response.ok((Object)v).build()).orElse(Response.noContent().build());
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"topicOwner", "admin"})
    @ApiOperation(value="Save schema", httpMethod="POST")
    public Response save(@PathParam(value="topicName") String qualifiedTopicName, @DefaultValue(value="true") @QueryParam(value="validate") boolean validate, @Context ContainerRequestContext requestContext, String schema) {
        Topic topic = this.topicService.getTopicDetails(TopicName.fromQualifiedName((String)qualifiedTopicName));
        HermesSecurityAwareRequestUser user = new HermesSecurityAwareRequestUser(requestContext);
        this.schemaService.registerSchema(topic, schema, validate);
        this.notifyFrontendSchemaChanged(qualifiedTopicName, user);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    private void notifyFrontendSchemaChanged(String qualifiedTopicName, RequestUser changedBy) {
        this.topicService.scheduleTouchTopic(TopicName.fromQualifiedName((String)qualifiedTopicName), changedBy);
    }

    @DELETE
    @RolesAllowed(value={"topicOwner", "admin"})
    @ApiOperation(value="Delete schema", httpMethod="DELETE")
    public Response delete(@PathParam(value="topicName") String qualifiedTopicName) {
        this.schemaService.deleteAllSchemaVersions(qualifiedTopicName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

