/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.topic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.OwnerId;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.management.domain.group.GroupService;

@Component
public class TopicOwnerCache {
    private static final Logger logger = LoggerFactory.getLogger(TopicOwnerCache.class);
    private final TopicRepository topicRepository;
    private final GroupService groupService;
    private final ScheduledExecutorService scheduledExecutorService;
    private Multimap<OwnerId, TopicName> cache = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());

    public TopicOwnerCache(TopicRepository topicRepository, GroupService groupService, @Value(value="${topicOwnerCache.refreshRateInSeconds}") int refreshRateInSeconds) {
        this.topicRepository = topicRepository;
        this.groupService = groupService;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("topic-owner-cache-%d").build());
        this.scheduledExecutorService.scheduleAtFixedRate(this::refillCache, 0L, refreshRateInSeconds, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        this.scheduledExecutorService.shutdown();
    }

    public Collection<TopicName> get(OwnerId ownerId) {
        return this.cache.get((Object)ownerId);
    }

    private void refillCache() {
        try {
            logger.info("Starting filling TopicOwnerCache cache");
            long start = System.currentTimeMillis();
            ArrayListMultimap cache = ArrayListMultimap.create();
            this.groupService.listGroupNames().stream().flatMap(groupName -> this.topicRepository.listTopics(groupName).stream()).forEach(arg_0 -> TopicOwnerCache.lambda$refillCache$1((Multimap)cache, arg_0));
            this.cache = Multimaps.synchronizedMultimap((Multimap)cache);
            long end = System.currentTimeMillis();
            logger.info("TopicOwnerCache filled. Took {}ms", (Object)(end - start));
        }
        catch (Exception e) {
            logger.error("Error while filling TopicOwnerCache", (Throwable)e);
        }
    }

    void onRemovedTopic(Topic topic) {
        this.cache.remove((Object)topic.getOwner(), (Object)topic.getName());
    }

    void onCreatedTopic(Topic topic) {
        this.cache.put((Object)topic.getOwner(), (Object)topic.getName());
    }

    void onUpdatedTopic(Topic oldTopic, Topic newTopic) {
        this.cache.remove((Object)oldTopic.getOwner(), (Object)oldTopic.getName());
        this.cache.put((Object)newTopic.getOwner(), (Object)newTopic.getName());
    }

    private static /* synthetic */ void lambda$refillCache$1(Multimap cache, Topic topic) {
        cache.put((Object)topic.getOwner(), (Object)topic.getName());
    }
}

