/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.prometheus;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import pl.allegro.tech.hermes.api.MetricDecimalValue;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringMetricsContainer;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.PrometheusClient;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.PrometheusResponse;

public class RestTemplatePrometheusClient
implements PrometheusClient {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplatePrometheusClient.class);
    private final URI prometheusUri;
    private final RestTemplate restTemplate;

    public RestTemplatePrometheusClient(RestTemplate restTemplate, URI prometheusUri) {
        this.restTemplate = restTemplate;
        this.prometheusUri = prometheusUri;
    }

    @Override
    public MonitoringMetricsContainer readMetrics(String query) {
        try {
            PrometheusResponse response = this.queryPrometheus(query);
            Preconditions.checkNotNull((Object)response, (Object)"Prometheus response is null");
            Preconditions.checkState((boolean)response.isSuccess(), (Object)"Prometheus response does not contain valid data");
            Map<String, List<PrometheusResponse.VectorResult>> metricsGroupedByName = RestTemplatePrometheusClient.groupMetricsByName(response);
            return RestTemplatePrometheusClient.produceMetricsContainer(metricsGroupedByName);
        }
        catch (Exception exception) {
            logger.warn("Unable to read from Prometheus...", (Throwable)exception);
            return MonitoringMetricsContainer.unavailable();
        }
    }

    private PrometheusResponse queryPrometheus(String query) {
        URI queryUri = URI.create(this.prometheusUri.toString() + "/api/v1/query?query=" + URLEncoder.encode(query, StandardCharsets.UTF_8));
        ResponseEntity response = this.restTemplate.exchange(queryUri, HttpMethod.GET, HttpEntity.EMPTY, PrometheusResponse.class);
        return (PrometheusResponse)response.getBody();
    }

    private static Map<String, List<PrometheusResponse.VectorResult>> groupMetricsByName(PrometheusResponse response) {
        return response.data().results().stream().map(RestTemplatePrometheusClient::renameStatusCodesMetricsNames).collect(Collectors.groupingBy(r -> r.metricName().name()));
    }

    private static MonitoringMetricsContainer produceMetricsContainer(Map<String, List<PrometheusResponse.VectorResult>> metricsGroupedByName) {
        MonitoringMetricsContainer metricsContainer = MonitoringMetricsContainer.createEmpty();
        Stream<Pair> metricsSummedByStatusCodeFamily = metricsGroupedByName.entrySet().stream().map(RestTemplatePrometheusClient::sumMetricsWithTheSameName);
        metricsSummedByStatusCodeFamily.forEach(pair -> metricsContainer.addMetricValue((String)pair.getKey(), MetricDecimalValue.of((String)((Double)pair.getValue()).toString())));
        return metricsContainer;
    }

    private static PrometheusResponse.VectorResult renameStatusCodesMetricsNames(PrometheusResponse.VectorResult r) {
        String suffix = "";
        if (r.metricName().is2xxStatusCode()) {
            suffix = "_2xx";
        } else if (r.metricName().is4xxStatusCode()) {
            suffix = "_4xx";
        } else if (r.metricName().is5xxStatusCode()) {
            suffix = "_5xx";
        }
        return r.renameMetric(r.metricName().name() + suffix);
    }

    private static Pair<String, Double> sumMetricsWithTheSameName(Map.Entry<String, List<PrometheusResponse.VectorResult>> e) {
        return Pair.of((Object)e.getKey(), (Object)e.getValue().stream().map(PrometheusResponse.VectorResult::getValue).filter(Optional::isPresent).map(Optional::get).mapToDouble(d -> d).sum());
    }
}

