/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.google.common.base.Ticker;
import java.net.URI;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.util.Timeout;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import pl.allegro.tech.hermes.management.config.ExternalMonitoringClientProperties;
import pl.allegro.tech.hermes.management.config.GraphiteMonitoringMetricsProperties;
import pl.allegro.tech.hermes.management.config.PrometheusMonitoringClientProperties;
import pl.allegro.tech.hermes.management.infrastructure.graphite.CachingGraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteMetricsProvider;
import pl.allegro.tech.hermes.management.infrastructure.graphite.RestTemplateGraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.CachingPrometheusClient;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.PrometheusClient;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.RestTemplatePrometheusClient;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.VictoriaMetricsMetricsProvider;

@Configuration
public class ExternalMonitoringConfiguration {
    @Bean
    @ConditionalOnProperty(value={"graphite.client.enabled"}, havingValue="true")
    public GraphiteMetricsProvider graphiteMetricsProvider(GraphiteClient graphiteClient, GraphiteMonitoringMetricsProperties properties) {
        return new GraphiteMetricsProvider(graphiteClient, properties.getPrefix());
    }

    @Bean
    @ConditionalOnProperty(value={"graphite.client.enabled"}, havingValue="true")
    public GraphiteClient graphiteClient(@Qualifier(value="monitoringRestTemplate") RestTemplate graphiteRestTemplate, GraphiteMonitoringMetricsProperties graphiteClientProperties) {
        RestTemplateGraphiteClient underlyingGraphiteClient = new RestTemplateGraphiteClient(graphiteRestTemplate, URI.create(graphiteClientProperties.getExternalMonitoringUrl()));
        return new CachingGraphiteClient(underlyingGraphiteClient, Ticker.systemTicker(), graphiteClientProperties.getCacheTtlSeconds(), graphiteClientProperties.getCacheSize());
    }

    @Bean
    @ConditionalOnProperty(value={"prometheus.client.enabled"}, havingValue="true")
    public VictoriaMetricsMetricsProvider prometheusMetricsProvider(PrometheusClient prometheusClient, PrometheusMonitoringClientProperties properties) {
        return new VictoriaMetricsMetricsProvider(prometheusClient, properties.getConsumersMetricsPrefix(), properties.getFrontendMetricsPrefix(), properties.getAdditionalFilters());
    }

    @Bean
    @ConditionalOnProperty(value={"prometheus.client.enabled"}, havingValue="true")
    public PrometheusClient prometheusClient(@Qualifier(value="monitoringRestTemplate") RestTemplate graphiteRestTemplate, PrometheusMonitoringClientProperties clientProperties) {
        RestTemplatePrometheusClient underlyingPrometheusClient = new RestTemplatePrometheusClient(graphiteRestTemplate, URI.create(clientProperties.getExternalMonitoringUrl()));
        return new CachingPrometheusClient(underlyingPrometheusClient, Ticker.systemTicker(), clientProperties.getCacheTtlSeconds(), clientProperties.getCacheSize());
    }

    @Bean(value={"monitoringRestTemplate"})
    public RestTemplate restTemplate(ExternalMonitoringClientProperties clientProperties) {
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnTotal(clientProperties.getMaxConnections()).setMaxConnPerRoute(clientProperties.getMaxConnectionsPerRoute()).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)clientProperties.getConnectionTimeoutMillis())).setResponseTimeout(Timeout.ofMilliseconds((long)clientProperties.getSocketTimeoutMillis())).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)client);
        return new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
    }
}

