/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api.auth;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import pl.allegro.tech.hermes.management.api.auth.SecurityProvider;

@Provider
@Priority(value=1999)
public class AuthorizationFilter
implements ContainerRequestFilter {
    public static final String OWNERSHIP_RESOLVER = "ownership-resolver";
    public static final int AUTHORIZATION_FILTER_PRIORITY = 1999;
    private final SecurityProvider securityProvider;

    @Autowired
    public AuthorizationFilter(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityProvider.HermesSecurity security = this.securityProvider.security(requestContext);
        requestContext.setSecurityContext(security.getSecurityContext());
        requestContext.setProperty(OWNERSHIP_RESOLVER, (Object)security.getOwnershipResolver());
    }
}

