/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config.storage;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import pl.allegro.tech.hermes.domain.CredentialsRepository;
import pl.allegro.tech.hermes.domain.group.GroupRepository;
import pl.allegro.tech.hermes.domain.oauth.OAuthProviderRepository;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.domain.topic.preview.MessagePreviewRepository;
import pl.allegro.tech.hermes.domain.workload.constraints.WorkloadConstraintsRepository;
import pl.allegro.tech.hermes.infrastructure.dc.DatacenterNameProvider;
import pl.allegro.tech.hermes.infrastructure.dc.DcNameSource;
import pl.allegro.tech.hermes.infrastructure.dc.DefaultDatacenterNameProvider;
import pl.allegro.tech.hermes.infrastructure.dc.EnvironmentVariableDatacenterNameProvider;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperCredentialsRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperGroupRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperMessagePreviewRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperOAuthProviderRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperSubscriptionRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperTopicRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperWorkloadConstraintsRepository;
import pl.allegro.tech.hermes.management.config.storage.DefaultZookeeperGroupRepositoryFactory;
import pl.allegro.tech.hermes.management.config.storage.StorageClustersProperties;
import pl.allegro.tech.hermes.management.config.storage.ZookeeperGroupRepositoryFactory;
import pl.allegro.tech.hermes.management.domain.blacklist.TopicBlacklistRepository;
import pl.allegro.tech.hermes.management.domain.dc.MultiDatacenterRepositoryCommandExecutor;
import pl.allegro.tech.hermes.management.domain.dc.MultiDatacenterRepositoryQueryExecutor;
import pl.allegro.tech.hermes.management.domain.mode.ModeService;
import pl.allegro.tech.hermes.management.domain.retransmit.OfflineRetransmissionRepository;
import pl.allegro.tech.hermes.management.infrastructure.blacklist.ZookeeperTopicBlacklistRepository;
import pl.allegro.tech.hermes.management.infrastructure.metrics.SummedSharedCounter;
import pl.allegro.tech.hermes.management.infrastructure.retransmit.ZookeeperOfflineRetransmissionRepository;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperClient;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperClientManager;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperRepositoryManager;

@Configuration
@EnableConfigurationProperties(value={StorageClustersProperties.class})
public class StorageConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(StorageConfiguration.class);
    @Autowired
    StorageClustersProperties storageClustersProperties;
    @Autowired
    ObjectMapper objectMapper;

    @Bean
    DatacenterNameProvider dcNameProvider() {
        if (this.storageClustersProperties.getDatacenterNameSource() == DcNameSource.ENV) {
            return new EnvironmentVariableDatacenterNameProvider(this.storageClustersProperties.getDatacenterNameSourceEnv());
        }
        return new DefaultDatacenterNameProvider();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    ZookeeperClientManager clientManager() {
        return new ZookeeperClientManager(this.storageClustersProperties, this.dcNameProvider());
    }

    @Bean
    ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory() {
        return new DefaultZookeeperGroupRepositoryFactory();
    }

    @Bean(initMethod="start")
    ZookeeperRepositoryManager repositoryManager(ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory) {
        return new ZookeeperRepositoryManager(this.clientManager(), this.dcNameProvider(), this.objectMapper, this.zookeeperPaths(), zookeeperGroupRepositoryFactory);
    }

    @Bean
    ZookeeperPaths zookeeperPaths() {
        return new ZookeeperPaths(this.storageClustersProperties.getPathPrefix());
    }

    @Bean
    MultiDatacenterRepositoryCommandExecutor multiDcRepositoryCommandExecutor(ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory, ModeService modeService) {
        return new MultiDatacenterRepositoryCommandExecutor(this.repositoryManager(zookeeperGroupRepositoryFactory), this.storageClustersProperties.isTransactional(), modeService);
    }

    @Bean
    MultiDatacenterRepositoryQueryExecutor multiDcRepositoryQueryExecutor(ZookeeperGroupRepositoryFactory zookeeperGroupRepositoryFactory) {
        return new MultiDatacenterRepositoryQueryExecutor(this.repositoryManager(zookeeperGroupRepositoryFactory));
    }

    @Bean
    SummedSharedCounter summedSharedCounter(ZookeeperClientManager manager) {
        return new SummedSharedCounter(manager.getClients(), this.storageClustersProperties.getSharedCountersExpiration(), this.storageClustersProperties.getRetrySleep(), this.storageClustersProperties.getRetryTimes());
    }

    @Bean
    GroupRepository groupRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperGroupRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    CredentialsRepository credentialsRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperCredentialsRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    TopicRepository topicRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperTopicRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths(), this.groupRepository());
    }

    @Bean
    SubscriptionRepository subscriptionRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperSubscriptionRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths(), this.topicRepository());
    }

    @Bean
    OAuthProviderRepository oAuthProviderRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperOAuthProviderRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    MessagePreviewRepository messagePreviewRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperMessagePreviewRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    TopicBlacklistRepository topicBlacklistRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperTopicBlacklistRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    WorkloadConstraintsRepository workloadConstraintsRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperWorkloadConstraintsRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    @Primary
    @Qualifier(value="zookeeperOfflineRetransmissionRepository")
    OfflineRetransmissionRepository zookeeperOfflineRetransmissionRepository() {
        ZookeeperClient localClient = this.clientManager().getLocalClient();
        return new ZookeeperOfflineRetransmissionRepository(localClient.getCuratorFramework(), this.objectMapper, this.zookeeperPaths());
    }
}

