/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.prometheus;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringMetricsContainer;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringSubscriptionMetricsProvider;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringTopicMetricsProvider;
import pl.allegro.tech.hermes.management.infrastructure.prometheus.PrometheusClient;

public class VictoriaMetricsMetricsProvider
implements MonitoringSubscriptionMetricsProvider,
MonitoringTopicMetricsProvider {
    private static final String SUBSCRIPTION_DELIVERED = "subscription_delivered_total";
    private static final String SUBSCRIPTION_TIMEOUTS = "subscription_timeouts_total";
    private static final String SUBSCRIPTION_THROUGHPUT = "subscription_throughput_bytes_total";
    private static final String SUBSCRIPTION_OTHER_ERRORS = "subscription_other_errors_total";
    private static final String SUBSCRIPTION_BATCHES = "subscription_batches_total";
    private static final String SUBSCRIPTION_STATUS_CODES = "subscription_http_status_codes_total";
    private static final String SUBSCRIPTION_STATUS_CODES_2XX = "subscription_http_status_codes_total_2xx";
    private static final String SUBSCRIPTION_STATUS_CODES_4XX = "subscription_http_status_codes_total_4xx";
    private static final String SUBSCRIPTION_STATUS_CODES_5XX = "subscription_http_status_codes_total_5xx";
    private static final String TOPIC_RATE = "topic_requests_total";
    private static final String TOPIC_DELIVERY_RATE = "subscription_delivered_total";
    private static final String TOPIC_THROUGHPUT_RATE = "topic_throughput_bytes_total";
    private final String consumersMetricsPrefix;
    private final String frontendMetricsPrefix;
    private final String additionalFilters;
    private final String subscriptionMetricsToQuery;
    private final String topicMetricsToQuery;
    private final PrometheusClient prometheusClient;

    public VictoriaMetricsMetricsProvider(PrometheusClient prometheusClient, String consumersMetricsPrefix, String frontendMetricsPrefix, String additionalFilters) {
        this.prometheusClient = prometheusClient;
        this.consumersMetricsPrefix = consumersMetricsPrefix.isEmpty() ? "" : consumersMetricsPrefix + "_";
        this.frontendMetricsPrefix = frontendMetricsPrefix.isEmpty() ? "" : frontendMetricsPrefix + "_";
        this.additionalFilters = additionalFilters;
        this.subscriptionMetricsToQuery = Stream.of("subscription_delivered_total", SUBSCRIPTION_TIMEOUTS, SUBSCRIPTION_THROUGHPUT, SUBSCRIPTION_OTHER_ERRORS, SUBSCRIPTION_BATCHES, SUBSCRIPTION_STATUS_CODES).map(this::consumerMetricName).collect(Collectors.joining("|"));
        this.topicMetricsToQuery = String.join((CharSequence)"|", List.of(this.frontendMetricName(TOPIC_RATE), this.consumerMetricName("subscription_delivered_total"), this.frontendMetricName(TOPIC_THROUGHPUT_RATE)));
    }

    @Override
    public MonitoringSubscriptionMetricsProvider.MonitoringSubscriptionMetrics subscriptionMetrics(SubscriptionName subscriptionName) {
        String queryFormat = "sum by (__name__, group, topic, subscription, status_code) (irate({__name__=~'%s', group='%s', topic='%s', subscription='%s', %s}[1m]) keep_metric_names)";
        String query = String.format(queryFormat, this.subscriptionMetricsToQuery, subscriptionName.getTopicName().getGroupName(), subscriptionName.getTopicName().getName(), subscriptionName.getName(), this.additionalFilters);
        MonitoringMetricsContainer prometheusMetricsContainer = this.prometheusClient.readMetrics(query);
        return MonitoringSubscriptionMetricsProvider.metricsBuilder().withRate(prometheusMetricsContainer.metricValue(this.consumerMetricName("subscription_delivered_total"))).withTimeouts(prometheusMetricsContainer.metricValue(this.consumerMetricName(SUBSCRIPTION_TIMEOUTS))).withThroughput(prometheusMetricsContainer.metricValue(this.consumerMetricName(SUBSCRIPTION_THROUGHPUT))).withOtherErrors(prometheusMetricsContainer.metricValue(this.consumerMetricName(SUBSCRIPTION_OTHER_ERRORS))).withMetricPathBatchRate(prometheusMetricsContainer.metricValue(this.consumerMetricName(SUBSCRIPTION_BATCHES))).withCodes2xx(prometheusMetricsContainer.metricValue(this.consumerMetricName(SUBSCRIPTION_STATUS_CODES_2XX))).withCode4xx(prometheusMetricsContainer.metricValue(this.consumerMetricName(SUBSCRIPTION_STATUS_CODES_4XX))).withCode5xx(prometheusMetricsContainer.metricValue(this.consumerMetricName(SUBSCRIPTION_STATUS_CODES_5XX))).build();
    }

    @Override
    public MonitoringTopicMetricsProvider.MonitoringTopicMetrics topicMetrics(TopicName topicName) {
        String queryFormat = "sum by (__name__, group, topic) (irate({__name__=~'%s', group='%s', topic='%s', %s}[1m]) keep_metric_names)";
        String query = String.format(queryFormat, this.topicMetricsToQuery, topicName.getGroupName(), topicName.getName(), this.additionalFilters);
        MonitoringMetricsContainer prometheusMetricsContainer = this.prometheusClient.readMetrics(query);
        return MonitoringTopicMetricsProvider.metricsBuilder().withRate(prometheusMetricsContainer.metricValue(this.frontendMetricName(TOPIC_RATE))).withDeliveryRate(prometheusMetricsContainer.metricValue(this.consumerMetricName("subscription_delivered_total"))).withThroughput(prometheusMetricsContainer.metricValue(this.frontendMetricName(TOPIC_THROUGHPUT_RATE))).build();
    }

    private String consumerMetricName(String name) {
        return this.consumersMetricsPrefix + name;
    }

    private String frontendMetricName(String name) {
        return this.frontendMetricsPrefix + name;
    }
}

