/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.mode;

import org.springframework.stereotype.Component;

@Component
public class ModeService {
    public static final String READ_WRITE = "readWrite";
    public static final String READ_ONLY = "readOnly";
    public static final String READ_ONLY_ADMIN = "readOnlyAdmin";
    private volatile ManagementMode mode = ManagementMode.READ_ONLY;

    public ManagementMode getMode() {
        return this.mode;
    }

    public synchronized void setModeByAdmin(ManagementMode mode) {
        this.mode = mode;
    }

    public boolean isReadOnlyEnabled() {
        return this.mode == ManagementMode.READ_ONLY || this.mode == ManagementMode.READ_ONLY_ADMIN;
    }

    public synchronized void setMode(ManagementMode newMode) {
        if (!this.mode.equals((Object)ManagementMode.READ_ONLY_ADMIN)) {
            this.mode = newMode;
        }
    }

    public static enum ManagementMode {
        READ_WRITE("readWrite"),
        READ_ONLY("readOnly"),
        READ_ONLY_ADMIN("readOnlyAdmin");

        private final String text;

        private ManagementMode(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

