/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.InconsistentGroup;
import pl.allegro.tech.hermes.management.api.auth.HermesSecurityAwareRequestUser;
import pl.allegro.tech.hermes.management.domain.consistency.DcConsistencyService;
import pl.allegro.tech.hermes.management.domain.consistency.KafkaHermesConsistencyService;

@Component
@RolesAllowed(value={"admin"})
@Path(value="consistency")
public class ConsistencyEndpoint {
    private final DcConsistencyService dcConsistencyService;
    private final KafkaHermesConsistencyService kafkaHermesConsistencyService;

    public ConsistencyEndpoint(DcConsistencyService dcConsistencyService, KafkaHermesConsistencyService kafkaHermesConsistencyService) {
        this.dcConsistencyService = dcConsistencyService;
        this.kafkaHermesConsistencyService = kafkaHermesConsistencyService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/inconsistencies/groups")
    public Response listInconsistentGroups(@QueryParam(value="groupNames") List<String> groupNames) {
        List<InconsistentGroup> inconsistentGroups = this.dcConsistencyService.listInconsistentGroups(new HashSet<String>(groupNames));
        return Response.ok().entity((Object)new GenericEntity<List<InconsistentGroup>>(inconsistentGroups){}).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/inconsistencies/topics")
    public Response listInconsistentTopics() {
        return Response.ok((Object)new GenericEntity<Set<String>>(this.kafkaHermesConsistencyService.listInconsistentTopics()){}).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/inconsistencies/topics")
    public Response removeTopicByName(@QueryParam(value="topicName") String topicName, @Context ContainerRequestContext requestContext) {
        this.kafkaHermesConsistencyService.removeTopic(topicName, new HermesSecurityAwareRequestUser(requestContext));
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/groups")
    public Response listAllGroups() {
        Set<String> groupNames = this.dcConsistencyService.listAllGroupNames();
        return Response.ok().entity((Object)new GenericEntity<Set<String>>(groupNames){}).build();
    }
}

