/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.dc;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.common.exception.RepositoryNotAvailableException;
import pl.allegro.tech.hermes.management.domain.auth.RequestUser;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.ExceptionWrapper;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryManager;
import pl.allegro.tech.hermes.management.domain.mode.ModeService;

public class MultiDatacenterRepositoryCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MultiDatacenterRepositoryCommandExecutor.class);
    private final RepositoryManager repositoryManager;
    private final boolean rollbackEnabled;
    private final ModeService modeService;

    public MultiDatacenterRepositoryCommandExecutor(RepositoryManager repositoryManager, boolean rollbackEnabled, ModeService modeService) {
        this.repositoryManager = repositoryManager;
        this.rollbackEnabled = rollbackEnabled;
        this.modeService = modeService;
    }

    public <T> void executeByUser(RepositoryCommand<T> command, RequestUser requestUser) {
        if (requestUser.isAdmin() && this.modeService.isReadOnlyEnabled()) {
            this.execute(command, false, false);
        } else {
            this.execute(command);
        }
    }

    public <T> void execute(RepositoryCommand<T> command) {
        this.execute(command, this.rollbackEnabled, true);
    }

    private <T> void execute(RepositoryCommand<T> command, boolean isRollbackEnabled, boolean shouldStopExecutionOnFailure) {
        if (isRollbackEnabled) {
            this.backup(command);
        }
        List<DatacenterBoundRepositoryHolder<T>> repoHolders = this.repositoryManager.getRepositories(command.getRepositoryType());
        ArrayList<DatacenterBoundRepositoryHolder<T>> executedRepoHolders = new ArrayList<DatacenterBoundRepositoryHolder<T>>();
        for (DatacenterBoundRepositoryHolder<T> repoHolder : repoHolders) {
            long start = System.currentTimeMillis();
            try {
                executedRepoHolders.add(repoHolder);
                logger.info("Executing repository command: {} in ZK dc: {}", command, (Object)repoHolder.getDatacenterName());
                command.execute(repoHolder);
                logger.info("Successfully executed repository command: {} in ZK dc: {} in: {} ms", new Object[]{command, repoHolder.getDatacenterName(), System.currentTimeMillis() - start});
            }
            catch (RepositoryNotAvailableException e) {
                logger.warn("Execute failed with an RepositoryNotAvailableException error", (Throwable)e);
                if (isRollbackEnabled) {
                    this.rollback(executedRepoHolders, command, (Exception)((Object)e));
                }
                if (!shouldStopExecutionOnFailure) continue;
                throw ExceptionWrapper.wrapInInternalProcessingExceptionIfNeeded((Exception)((Object)e), command.toString(), repoHolder.getDatacenterName());
            }
            catch (Exception e) {
                logger.warn("Failed to execute repository command: {} in ZK dc: {} in: {} ms", new Object[]{command, repoHolder.getDatacenterName(), System.currentTimeMillis() - start, e});
                if (isRollbackEnabled) {
                    this.rollback(executedRepoHolders, command, e);
                }
                throw ExceptionWrapper.wrapInInternalProcessingExceptionIfNeeded(e, command.toString(), repoHolder.getDatacenterName());
            }
        }
    }

    private <T> void rollback(List<DatacenterBoundRepositoryHolder<T>> repoHolders, RepositoryCommand<T> command, Exception exception) {
        long start = System.currentTimeMillis();
        for (DatacenterBoundRepositoryHolder<T> repoHolder : repoHolders) {
            logger.info("Executing rollback of repository command: {} in ZK dc: {}", command, (Object)repoHolder.getDatacenterName());
            try {
                command.rollback(repoHolder, exception);
                logger.info("Successfully executed rollback of repository command: {} in ZK dc: {} in: {} ms", new Object[]{command, repoHolder.getDatacenterName(), System.currentTimeMillis() - start});
            }
            catch (Exception e) {
                logger.error("Rollback procedure failed for command {} on DC {}", new Object[]{command, repoHolder.getDatacenterName(), e});
            }
        }
    }

    private <T> void backup(RepositoryCommand<T> command) {
        DatacenterBoundRepositoryHolder<T> repoHolder = this.repositoryManager.getLocalRepository(command.getRepositoryType());
        try {
            logger.debug("Creating backup for command: {}", command);
            command.backup(repoHolder);
        }
        catch (Exception e) {
            throw new InternalProcessingException("Backup procedure for command '" + command + "' failed on DC '" + repoHolder.getDatacenterName() + "'.", (Throwable)e);
        }
    }
}

