/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.commands;

import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionAlreadyExistsException;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;

public class CreateSubscriptionRepositoryCommand
extends RepositoryCommand<SubscriptionRepository> {
    private final Subscription subscription;

    public CreateSubscriptionRepositoryCommand(Subscription subscription) {
        this.subscription = subscription;
    }

    @Override
    public void backup(DatacenterBoundRepositoryHolder<SubscriptionRepository> holder) {
    }

    @Override
    public void execute(DatacenterBoundRepositoryHolder<SubscriptionRepository> holder) {
        holder.getRepository().createSubscription(this.subscription);
    }

    @Override
    public void rollback(DatacenterBoundRepositoryHolder<SubscriptionRepository> holder, Exception exception) {
        if (exception instanceof SubscriptionAlreadyExistsException) {
            return;
        }
        holder.getRepository().removeSubscription(this.subscription.getTopicName(), this.subscription.getName());
    }

    @Override
    public Class<SubscriptionRepository> getRepositoryType() {
        return SubscriptionRepository.class;
    }

    public String toString() {
        return "CreateSubscription(" + this.subscription.getQualifiedName() + ")";
    }
}

