/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.workload.constraints.command;

import pl.allegro.tech.hermes.api.Constraints;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.workload.constraints.WorkloadConstraintsRepository;
import pl.allegro.tech.hermes.management.domain.dc.DatacenterBoundRepositoryHolder;
import pl.allegro.tech.hermes.management.domain.dc.RepositoryCommand;

public class DeleteTopicConstraintsRepositoryCommand
extends RepositoryCommand<WorkloadConstraintsRepository> {
    private final TopicName topicName;
    private Constraints backup;

    public DeleteTopicConstraintsRepositoryCommand(TopicName topicName) {
        this.topicName = topicName;
    }

    @Override
    public void backup(DatacenterBoundRepositoryHolder<WorkloadConstraintsRepository> holder) {
        this.backup = (Constraints)holder.getRepository().getConsumersWorkloadConstraints().getTopicConstraints().get(this.topicName);
    }

    @Override
    public void execute(DatacenterBoundRepositoryHolder<WorkloadConstraintsRepository> holder) {
        holder.getRepository().deleteConstraints(this.topicName);
    }

    @Override
    public void rollback(DatacenterBoundRepositoryHolder<WorkloadConstraintsRepository> holder, Exception exception) {
        if (this.backup != null) {
            holder.getRepository().createConstraints(this.topicName, this.backup);
        }
    }

    @Override
    public Class<WorkloadConstraintsRepository> getRepositoryType() {
        return WorkloadConstraintsRepository.class;
    }

    public String toString() {
        return String.format("DeleteTopicConstraints(%s)", this.topicName.qualifiedName());
    }
}

