/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.prometheus;

import java.util.List;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringMetricsContainer;

public interface PrometheusClient {
    public static final String SUBSCRIPTION_QUERY_FORMAT = "sum by (group, topic, subscription) (irate({__name__='%s', group='%s', topic='%s', subscription='%s', %s}[1m]))";
    public static final String SUBSCRIPTION_QUERY_FORMAT_STATUS_CODE = "sum by (group, topic, subscription) (irate({__name__='%s', group='%s', topic='%s', subscription='%s', status_code=~'%s', %s}[1m]))";
    public static final String TOPIC_QUERY_FORMAT = "sum by (group, topic) (irate({__name__='%s', group='%s', topic='%s', %s}[1m]))";

    default public MonitoringMetricsContainer readMetrics(String ... query) {
        return this.readMetrics(List.of(query));
    }

    public MonitoringMetricsContainer readMetrics(List<String> var1);

    public static String forSubscription(String name, SubscriptionName subscriptionName, String additionalFilters) {
        return String.format(SUBSCRIPTION_QUERY_FORMAT, name, subscriptionName.getTopicName().getGroupName(), subscriptionName.getTopicName().getName(), subscriptionName.getName(), additionalFilters);
    }

    public static String forSubscriptionStatusCode(String name, SubscriptionName subscriptionName, String regex, String additionalFilters) {
        return String.format(SUBSCRIPTION_QUERY_FORMAT_STATUS_CODE, name, subscriptionName.getTopicName().getGroupName(), subscriptionName.getTopicName().getName(), subscriptionName.getName(), regex, additionalFilters);
    }

    public static String forTopic(String name, TopicName topicName, String additionalFilters) {
        return String.format(TOPIC_QUERY_FORMAT, name, topicName.getGroupName(), topicName.getName(), additionalFilters);
    }
}

