/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import io.swagger.annotations.Api;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.OfflineRetransmissionRequest;
import pl.allegro.tech.hermes.api.OfflineRetransmissionTask;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.management.api.auth.ManagementRights;
import pl.allegro.tech.hermes.management.domain.PermissionDeniedException;
import pl.allegro.tech.hermes.management.domain.retransmit.OfflineRetransmissionService;

@Component
@Path(value="offline-retransmission/tasks")
@Api(value="offline-retransmission/tasks", description="Offline retransmission operations")
public class OfflineRetransmissionEndpoint {
    private final OfflineRetransmissionService retransmissionService;
    private final RetransmissionPermissions permissions;
    private final OfflineRetransmissionAuditor auditor;

    public OfflineRetransmissionEndpoint(OfflineRetransmissionService retransmissionService, TopicRepository topicRepository, ManagementRights managementRights) {
        this.retransmissionService = retransmissionService;
        this.permissions = new RetransmissionPermissions(topicRepository, managementRights);
        this.auditor = new OfflineRetransmissionAuditor();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createRetransmissionTask(@Valid OfflineRetransmissionRequest request, @Context ContainerRequestContext requestContext) {
        this.retransmissionService.validateRequest(request);
        this.permissions.ensurePermissionsToBothTopics(request, requestContext);
        this.retransmissionService.createTask(request);
        this.auditor.auditRetransmissionCreation(request, requestContext);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Produces(value={"application/json"})
    public List<OfflineRetransmissionTask> getAllRetransmissionTasks() {
        return this.retransmissionService.getAllTasks();
    }

    @DELETE
    @Path(value="/{taskId}")
    public Response deleteRetransmissionTask(@PathParam(value="taskId") String taskId) {
        this.retransmissionService.deleteTask(taskId);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private static class RetransmissionPermissions {
        private final TopicRepository topicRepository;
        private final ManagementRights managementRights;

        private RetransmissionPermissions(TopicRepository topicRepository, ManagementRights managementRights) {
            this.topicRepository = topicRepository;
            this.managementRights = managementRights;
        }

        private void ensurePermissionsToBothTopics(OfflineRetransmissionRequest request, ContainerRequestContext requestContext) {
            boolean hasPermissions;
            Topic sourceTopic = this.topicRepository.getTopicDetails(TopicName.fromQualifiedName((String)request.getSourceTopic()));
            Topic targetTopic = this.topicRepository.getTopicDetails(TopicName.fromQualifiedName((String)request.getTargetTopic()));
            boolean bl = hasPermissions = this.managementRights.isUserAllowedToManageTopic(sourceTopic, requestContext) && this.managementRights.isUserAllowedToManageTopic(targetTopic, requestContext);
            if (!hasPermissions) {
                throw new PermissionDeniedException("User needs permissions to source and target topics.");
            }
        }
    }

    private static class OfflineRetransmissionAuditor {
        private static final Logger logger = LoggerFactory.getLogger(OfflineRetransmissionAuditor.class);

        private OfflineRetransmissionAuditor() {
        }

        public void auditRetransmissionCreation(OfflineRetransmissionRequest request, ContainerRequestContext requestContext) {
            String username = this.extractUsername(requestContext);
            logger.info("User {} created retransmission task: {}", (Object)username, (Object)request);
        }

        private String extractUsername(ContainerRequestContext requestContext) {
            return requestContext.getSecurityContext().getUserPrincipal().getName();
        }
    }
}

