/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health.problem;

import java.util.Optional;
import pl.allegro.tech.hermes.api.SubscriptionHealthProblem;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContext;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthProblemIndicator;

public class MalfunctioningIndicator
implements SubscriptionHealthProblemIndicator {
    private final double max5xxErrorsRatio;
    private final double minSubscriptionRateForReliableMetrics;

    public MalfunctioningIndicator(double max5xxErrorsRatio, double minSubscriptionRateForReliableMetrics) {
        this.max5xxErrorsRatio = max5xxErrorsRatio;
        this.minSubscriptionRateForReliableMetrics = minSubscriptionRateForReliableMetrics;
    }

    @Override
    public Optional<SubscriptionHealthProblem> getProblem(SubscriptionHealthContext context) {
        if (this.areSubscriptionMetricsReliable(context) && this.isCode5xxErrorsRateHigh(context)) {
            return Optional.of(SubscriptionHealthProblem.malfunctioning((double)context.getCode5xxErrorsRate(), (String)context.getSubscription().getQualifiedName().toString()));
        }
        return Optional.empty();
    }

    private boolean areSubscriptionMetricsReliable(SubscriptionHealthContext context) {
        return context.getSubscriptionRateRespectingDeliveryType() > this.minSubscriptionRateForReliableMetrics;
    }

    private boolean isCode5xxErrorsRateHigh(SubscriptionHealthContext context) {
        double rate;
        double code5xxErrorsRate = context.getCode5xxErrorsRate();
        return code5xxErrorsRate > this.max5xxErrorsRatio * (rate = context.getSubscriptionRateRespectingDeliveryType());
    }
}

