/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.graphite;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.api.MetricDecimalValue;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.metrics.MonitoringMetricsContainer;

public class CachingGraphiteClient
implements GraphiteClient {
    private final GraphiteClient underlyingGraphiteClient;
    private final LoadingCache<String, MetricDecimalValue> graphiteMetricsCache;

    public CachingGraphiteClient(GraphiteClient underlyingGraphiteClient, Ticker ticker, long cacheTtlInSeconds, long cacheSize) {
        this.underlyingGraphiteClient = underlyingGraphiteClient;
        this.graphiteMetricsCache = CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(cacheTtlInSeconds, TimeUnit.SECONDS).maximumSize(cacheSize).build((CacheLoader)new GraphiteMetricsCacheLoader());
    }

    @Override
    public MonitoringMetricsContainer readMetrics(String ... metricPaths) {
        try {
            ImmutableMap graphiteMetrics = this.graphiteMetricsCache.getAll(Arrays.asList(metricPaths));
            return MonitoringMetricsContainer.initialized((Map<String, MetricDecimalValue>)graphiteMetrics);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private class GraphiteMetricsCacheLoader
    extends CacheLoader<String, MetricDecimalValue> {
        private GraphiteMetricsCacheLoader() {
        }

        public MetricDecimalValue load(String metricPath) {
            return this.loadAll(Collections.singleton(metricPath)).get(metricPath);
        }

        public Map<String, MetricDecimalValue> loadAll(Iterable<? extends String> metricPaths) {
            String[] metricPathsArray = (String[])Iterables.toArray(metricPaths, String.class);
            MonitoringMetricsContainer metricsContainer = CachingGraphiteClient.this.underlyingGraphiteClient.readMetrics(metricPathsArray);
            return Arrays.stream(metricPathsArray).collect(Collectors.toMap(Function.identity(), metricsContainer::metricValue));
        }
    }
}

