/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.metrics;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.retry.ExponentialBackoffRetry;
import pl.allegro.tech.hermes.infrastructure.zookeeper.counter.ZookeeperCounterException;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperClient;

public class SummedSharedCounter {
    private final LoadingCache<String, CounterAggregator> counterAggregators;

    public SummedSharedCounter(List<ZookeeperClient> zookeeperClients, int expireAfter, int distributedLoaderBackoff, int distributedLoaderRetries) {
        this.counterAggregators = this.buildLoadingCache(zookeeperClients, expireAfter, distributedLoaderBackoff, distributedLoaderRetries);
    }

    public long getValue(String path) {
        try {
            return ((CounterAggregator)this.counterAggregators.get((Object)path)).aggregate();
        }
        catch (ZookeeperCounterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZookeeperCounterException(path, (Throwable)e);
        }
    }

    private LoadingCache<String, CounterAggregator> buildLoadingCache(final List<ZookeeperClient> zookeeperClients, int expireAfter, final int distributedLoaderBackoff, final int distributedLoaderRetries) {
        return CacheBuilder.newBuilder().expireAfterAccess((long)expireAfter, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, CounterAggregator>(){

            public CounterAggregator load(String key) {
                return new CounterAggregator(key, zookeeperClients, distributedLoaderBackoff, distributedLoaderRetries);
            }
        });
    }

    private static class CounterAggregator {
        private final String counterName;
        private final Map<String, CuratorFramework> curatorPerDatacenter = new HashMap<String, CuratorFramework>();
        private final Map<String, DistributedAtomicLong> counterPerDatacenter = new HashMap<String, DistributedAtomicLong>();

        CounterAggregator(String counterName, List<ZookeeperClient> zookeeperClients, int distributedLoaderBackoff, int distributedLoaderRetries) {
            this.counterName = counterName;
            for (ZookeeperClient zookeeperClient : zookeeperClients) {
                CuratorFramework curatorFramework = zookeeperClient.getCuratorFramework();
                this.curatorPerDatacenter.put(zookeeperClient.getDatacenterName(), curatorFramework);
                DistributedAtomicLong distributedAtomicLong = new DistributedAtomicLong(curatorFramework, counterName, (RetryPolicy)new ExponentialBackoffRetry(distributedLoaderBackoff, distributedLoaderRetries));
                this.counterPerDatacenter.put(zookeeperClient.getDatacenterName(), distributedAtomicLong);
            }
        }

        long aggregate() throws Exception {
            long sum = 0L;
            for (Map.Entry<String, DistributedAtomicLong> counterEntry : this.counterPerDatacenter.entrySet()) {
                this.ensureConnected(counterEntry.getKey());
                DistributedAtomicLong counter = counterEntry.getValue();
                sum += ((Long)counter.get().preValue()).longValue();
            }
            return sum;
        }

        private void ensureConnected(String datacenter) {
            CuratorFramework curator = this.curatorPerDatacenter.get(datacenter);
            if (!curator.getZookeeperClient().isConnected()) {
                throw new ZookeeperCounterException(this.counterName, "Could not establish connection to a Zookeeper instance in " + datacenter + ".");
            }
        }
    }
}

