/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import pl.allegro.tech.hermes.api.OwnerId;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSource;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSourceNotFound;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSources;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionService;

@Path(value="subscriptions/owner")
public class SubscriptionsOwnershipEndpoint {
    private final OwnerSources ownerSources;
    private final SubscriptionService subscriptionService;

    @Autowired
    public SubscriptionsOwnershipEndpoint(OwnerSources ownerSources, SubscriptionService subscriptionService) {
        this.ownerSources = ownerSources;
        this.subscriptionService = subscriptionService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{ownerSourceName}/{ownerId}")
    public List<Subscription> listForOwner(@PathParam(value="ownerSourceName") String ownerSourceName, @PathParam(value="ownerId") String id) {
        OwnerId ownerId = this.resolveOwnerId(ownerSourceName, id);
        return this.subscriptionService.getForOwnerId(ownerId);
    }

    private OwnerId resolveOwnerId(String ownerSourceName, String id) {
        OwnerSource ownerSource = this.ownerSources.getByName(ownerSourceName).orElseThrow(() -> new OwnerSourceNotFound(ownerSourceName));
        if (!ownerSource.exists(id)) {
            throw new OwnerSource.OwnerNotFound(ownerSourceName, id);
        }
        return new OwnerId(ownerSource.name(), id);
    }
}

