/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.retransmit;

import java.util.List;
import pl.allegro.tech.hermes.api.OfflineRetransmissionTask;
import pl.allegro.tech.hermes.management.domain.dc.MultiDatacenterRepositoryCommandExecutor;
import pl.allegro.tech.hermes.management.domain.retransmit.CreateOfflineRetransmissionTaskCommand;
import pl.allegro.tech.hermes.management.domain.retransmit.DeleteOfflineRetransmissionTaskCommand;
import pl.allegro.tech.hermes.management.domain.retransmit.OfflineRetransmissionRepository;

public class DcAwareOfflineRetransmissionRepository
implements OfflineRetransmissionRepository {
    private final MultiDatacenterRepositoryCommandExecutor commandExecutor;
    private final OfflineRetransmissionRepository offlineRetransmissionRepository;

    public DcAwareOfflineRetransmissionRepository(MultiDatacenterRepositoryCommandExecutor commandExecutor, OfflineRetransmissionRepository offlineRetransmissionRepository) {
        this.commandExecutor = commandExecutor;
        this.offlineRetransmissionRepository = offlineRetransmissionRepository;
    }

    @Override
    public void saveTask(OfflineRetransmissionTask task) {
        this.commandExecutor.execute(new CreateOfflineRetransmissionTaskCommand(task));
    }

    @Override
    public List<OfflineRetransmissionTask> getAllTasks() {
        return this.offlineRetransmissionRepository.getAllTasks();
    }

    @Override
    public void deleteTask(String taskId) {
        this.commandExecutor.execute(new DeleteOfflineRetransmissionTaskCommand(taskId));
    }
}

