/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.filtering;

import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.MessageFiltersVerificationInput;
import pl.allegro.tech.hermes.api.MessageFiltersVerificationResult;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.domain.filtering.FilterableMessage;
import pl.allegro.tech.hermes.domain.filtering.chain.FilterChain;
import pl.allegro.tech.hermes.domain.filtering.chain.FilterChainFactory;
import pl.allegro.tech.hermes.domain.filtering.chain.FilterResult;
import pl.allegro.tech.hermes.management.domain.filtering.MessageForFiltersVerification;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.schema.CompiledSchema;
import pl.allegro.tech.hermes.schema.SchemaRepository;
import tech.allegro.schema.json2avro.converter.AvroConversionException;
import tech.allegro.schema.json2avro.converter.JsonAvroConverter;

@Component
public class FilteringService {
    private final FilterChainFactory filterChainFactory;
    private final SchemaRepository schemaRepository;
    private final TopicService topicService;
    private final JsonAvroConverter jsonAvroConverter;

    public FilteringService(FilterChainFactory filterChainFactory, SchemaRepository schemaRepository, TopicService topicService, JsonAvroConverter jsonAvroConverter) {
        this.filterChainFactory = filterChainFactory;
        this.schemaRepository = schemaRepository;
        this.topicService = topicService;
        this.jsonAvroConverter = jsonAvroConverter;
    }

    public MessageFiltersVerificationResult verify(MessageFiltersVerificationInput verification, TopicName topicName) {
        byte[] messageContent;
        Topic topic = this.topicService.getTopicDetails(topicName);
        CompiledSchema<Schema> avroSchema = this.getLatestAvroSchemaIfExists(topic);
        try {
            messageContent = this.getBytes(verification.getMessage(), topic, avroSchema);
        }
        catch (AvroConversionException e) {
            return new MessageFiltersVerificationResult(MessageFiltersVerificationResult.VerificationStatus.ERROR, this.createErrorMessage(e));
        }
        MessageForFiltersVerification message = new MessageForFiltersVerification(messageContent, topic.getContentType(), avroSchema);
        FilterChain filterChain = this.filterChainFactory.create(verification.getFilters());
        FilterResult result = filterChain.apply((FilterableMessage)message);
        return this.toMessageFiltersVerificationResult(result);
    }

    private CompiledSchema<Schema> getLatestAvroSchemaIfExists(Topic topic) {
        if (ContentType.AVRO.equals((Object)topic.getContentType())) {
            return this.schemaRepository.getLatestAvroSchema(topic);
        }
        return null;
    }

    private byte[] getBytes(byte[] message, Topic topic, CompiledSchema<Schema> avroSchema) {
        switch (topic.getContentType()) {
            case JSON: {
                return message;
            }
            case AVRO: {
                return this.jsonAvroConverter.convertToAvro(message, (Schema)avroSchema.getSchema());
            }
        }
        throw new IllegalArgumentException();
    }

    private MessageFiltersVerificationResult toMessageFiltersVerificationResult(FilterResult result) {
        return new MessageFiltersVerificationResult(result.isFiltered() ? MessageFiltersVerificationResult.VerificationStatus.NOT_MATCHED : MessageFiltersVerificationResult.VerificationStatus.MATCHED, (String)result.getCause().map(this::createErrorMessage).orElse(null));
    }

    private String createErrorMessage(Throwable th) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)th);
        return Stream.of(th.getMessage(), rootCause != null ? rootCause.getMessage() : null).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }
}

