/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Group;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.management.api.auth.HermesSecurityAwareRequestUser;
import pl.allegro.tech.hermes.management.api.auth.ManagementRights;
import pl.allegro.tech.hermes.management.api.validator.ApiPreconditions;
import pl.allegro.tech.hermes.management.domain.group.GroupService;

@Component
@Path(value="/groups")
@Api(value="/groups", description="Operations on groups")
public class GroupsEndpoint {
    private final GroupService groupService;
    private final ApiPreconditions preconditions;
    private final ManagementRights managementRights;

    @Autowired
    public GroupsEndpoint(GroupService groupService, ApiPreconditions preconditions, ManagementRights managementRights) {
        this.groupService = groupService;
        this.preconditions = preconditions;
        this.managementRights = managementRights;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List groups", response=List.class, httpMethod="GET")
    public List<String> list() {
        return this.groupService.listGroupNames();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{groupName}")
    @ApiOperation(value="Get group details", response=Group.class, httpMethod="GET")
    public Group get(@PathParam(value="groupName") String groupName) {
        return this.groupService.getGroupDetails(groupName);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create group", response=String.class, httpMethod="POST")
    @RolesAllowed(value={"any"})
    public Response create(Group group, @Context ContainerRequestContext requestContext) {
        this.preconditions.checkConstraints(group, false);
        this.groupService.createGroup(group, new HermesSecurityAwareRequestUser(requestContext), this.managementRights.getGroupCreatorRights(requestContext));
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{groupName}")
    @ApiOperation(value="Update group", response=String.class, httpMethod="PUT")
    @RolesAllowed(value={"admin"})
    public Response update(@PathParam(value="groupName") String groupName, PatchData patch, @Context ContainerRequestContext requestContext) {
        this.groupService.updateGroup(groupName, patch, new HermesSecurityAwareRequestUser(requestContext));
        return this.responseStatus(Response.Status.NO_CONTENT);
    }

    @DELETE
    @Path(value="/{groupName}")
    @ApiOperation(value="Remove group", response=String.class, httpMethod="DELETE")
    @RolesAllowed(value={"any"})
    public Response delete(@PathParam(value="groupName") String groupName, @Context ContainerRequestContext requestContext) {
        this.groupService.removeGroup(groupName, new HermesSecurityAwareRequestUser(requestContext));
        return this.responseStatus(Response.Status.OK);
    }

    private Response responseStatus(Response.Status responseStatus) {
        return Response.status((Response.Status)responseStatus).build();
    }
}

