/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.audit;

import com.google.common.base.Preconditions;
import java.util.Collection;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.management.domain.Auditor;

public class CompositeAuditor
implements Auditor {
    private final Collection<Auditor> auditors;

    public CompositeAuditor(Collection<Auditor> auditors) {
        this.auditors = (Collection)Preconditions.checkNotNull(auditors);
    }

    @Override
    public void beforeObjectCreation(String username, Object createdObject) {
        this.auditors.forEach(auditor -> auditor.beforeObjectCreation(username, createdObject));
    }

    @Override
    public void beforeObjectRemoval(String username, String removedObjectType, String removedObjectName) {
        this.auditors.forEach(auditor -> auditor.beforeObjectRemoval(username, removedObjectType, removedObjectName));
    }

    @Override
    public void beforeObjectUpdate(String username, String objectClassName, Object objectName, PatchData patchData) {
        this.auditors.forEach(auditor -> auditor.beforeObjectUpdate(username, objectClassName, objectName, patchData));
    }

    @Override
    public void objectCreated(String username, Object createdObject) {
        this.auditors.forEach(auditor -> auditor.objectCreated(username, createdObject));
    }

    @Override
    public void objectRemoved(String username, Object removedObject) {
        this.auditors.forEach(auditor -> auditor.objectRemoved(username, removedObject));
    }

    @Override
    public void objectUpdated(String username, Object oldObject, Object newObject) {
        this.auditors.forEach(auditor -> auditor.objectUpdated(username, oldObject, newObject));
    }
}

