/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.prometheus;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;

record PrometheusResponse(@JsonProperty(value="status") String status, @JsonProperty(value="data") Data data) {
    boolean isSuccess() {
        return this.status.equals("success") && this.data.isVector();
    }

    record Data(@JsonProperty(value="resultType") String resultType, @JsonProperty(value="result") List<VectorResult> results) {
        boolean isVector() {
            return this.resultType.equals("vector");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    record VectorResult(@JsonProperty(value="value") List<String> vector) {
        private static final int VALID_VECTOR_LENGTH = 2;
        private static final int SCALAR_INDEX_VALUE = 1;

        Optional<Double> getValue() {
            if (this.vector.size() != 2) {
                return Optional.empty();
            }
            return Optional.of(Double.parseDouble(this.vector.get(1)));
        }
    }
}

