/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

class FieldAccessExpressionNode
implements OpelNode {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OpelNode subject;
    private final OpelNode fieldName;

    public FieldAccessExpressionNode(OpelNode subject, OpelNode fieldName) {
        this.subject = subject;
        this.fieldName = fieldName;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return this.extractValueFromMap(this.subject.getValue(context), this.fieldName.getValue(context));
    }

    private CompletableFuture<?> extractValueFromMap(CompletableFuture<?> obj, CompletableFuture<?> key) {
        return obj.thenCombine(key, (it, k) -> {
            if (it == null) {
                logger.info("Can't extract value for key '" + k + "' from null");
                return null;
            }
            if (it instanceof Map) {
                return ((Map)it).get(k);
            }
            throw new OpelException("Give me a map, given " + it.getClass().getSimpleName());
        });
    }
}

