/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.OpelAsyncFunction;

public class EvalContextBuilder {
    private final Map<String, CompletableFuture<?>> values = new HashMap();
    private Optional<EvalContext> externalEvalContext = Optional.empty();

    static EvalContext fromMap(Map<String, CompletableFuture<?>> values) {
        HashMap copiedValues = new HashMap(values);
        return name -> Optional.ofNullable((CompletableFuture)copiedValues.get(name));
    }

    public static EvalContextBuilder create() {
        return new EvalContextBuilder();
    }

    public EvalContextBuilder withExternalEvalContext(EvalContext evalContext) {
        this.externalEvalContext = Optional.of(evalContext);
        return this;
    }

    public EvalContextBuilder withValue(String valueName, CompletableFuture<Object> value) {
        this.values.put(valueName, value);
        return this;
    }

    public EvalContextBuilder withValues(Map<String, CompletableFuture<?>> values) {
        this.values.putAll(values);
        return this;
    }

    public EvalContextBuilder withCompletedValue(String valueName, Object value) {
        this.values.put(valueName, CompletableFuture.completedFuture(value));
        return this;
    }

    @Deprecated
    public EvalContextBuilder withFunction(String functionName, OpelAsyncFunction<?> function) {
        return this.withCompletedValue(functionName, function);
    }

    @Deprecated
    public EvalContextBuilder withFunctions(Map<String, OpelAsyncFunction<?>> functions) {
        functions.forEach(this::withCompletedValue);
        return this;
    }

    public boolean hasValue(String valueName) {
        return this.values.containsKey(valueName);
    }

    public EvalContext build() {
        return this.externalEvalContext.map(external -> EvalContextBuilder.mergeContexts(EvalContextBuilder.fromMap(this.values), external)).orElseGet(() -> EvalContextBuilder.fromMap(this.values));
    }

    static EvalContext mergeContexts(EvalContext primary, EvalContext secondary) {
        return name -> {
            Optional<CompletableFuture<?>> value = primary.getValue(name);
            return value.isPresent() ? value : secondary.getValue(name);
        };
    }
}

