/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import pl.allegro.tech.opel.BinaryOperationExpressionNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.OpelLogicalExpressionException;
import pl.allegro.tech.opel.OpelNode;
import pl.allegro.tech.opel.Operator;

class LogicalOperatorExpressionNode
extends BinaryOperationExpressionNode {
    private final Operator logicalOperator;
    private final ImplicitConversion conversion;

    private LogicalOperatorExpressionNode(Operator logicalOperator, OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        super(left, right);
        this.logicalOperator = logicalOperator;
        this.conversion = implicitConversion;
    }

    static LogicalOperatorExpressionNode andOperator(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        return new LogicalOperatorExpressionNode(Operator.AND, left, right, implicitConversion);
    }

    static LogicalOperatorExpressionNode orOperator(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        return new LogicalOperatorExpressionNode(Operator.OR, left, right, implicitConversion);
    }

    public CompletableFuture<Boolean> getValue(EvalContext context) {
        return this.left().getValue(context).thenCompose(left -> this.wrappingExceptionsWithOpelException(left, () -> {
            if (this.logicalOperator == Operator.OR && Boolean.TRUE.equals(this.conversion.convert(left, Boolean.class))) {
                return CompletableFuture.completedFuture(true);
            }
            if (this.logicalOperator == Operator.AND && Boolean.FALSE.equals(this.conversion.convert(left, Boolean.class))) {
                return CompletableFuture.completedFuture(false);
            }
            return this.right().getValue(context).thenApply(right -> this.wrappingExceptionsWithOpelException(left, right, () -> Boolean.TRUE.equals(this.conversion.convert(right, Boolean.class))));
        }));
    }

    private <T> T wrappingExceptionsWithOpelException(Object left, Supplier<T> wrappedBody) {
        try {
            return wrappedBody.get();
        }
        catch (Exception e) {
            throw new OpelLogicalExpressionException(this.logicalOperator, left, e);
        }
    }

    private <T> T wrappingExceptionsWithOpelException(Object left, Object right, Supplier<T> wrappedBody) {
        try {
            return wrappedBody.get();
        }
        catch (Exception e) {
            throw new OpelLogicalExpressionException(this.logicalOperator, left, right, e);
        }
    }
}

