/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.opel.BinaryOperationExpressionNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.OpelNode;

class EqualOperatorExpressionNode
extends BinaryOperationExpressionNode {
    private static final Logger logger = LoggerFactory.getLogger(EqualOperatorExpressionNode.class);
    private final boolean equal;
    private final ImplicitConversion implicitConversion;

    private EqualOperatorExpressionNode(boolean equal, OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        super(left, right);
        this.equal = equal;
        this.implicitConversion = implicitConversion;
    }

    public static EqualOperatorExpressionNode equalityOperator(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        return new EqualOperatorExpressionNode(true, left, right, implicitConversion);
    }

    public static EqualOperatorExpressionNode inequalityOperator(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        return new EqualOperatorExpressionNode(false, left, right, implicitConversion);
    }

    public CompletableFuture<Boolean> getValue(EvalContext context) {
        return this.left().getValue(context).thenCombine(this.right().getValue(context), (left, right) -> {
            try {
                if (left == null && right == null) {
                    return this.equal;
                }
                if (left == null || right == null) {
                    return !this.equal;
                }
                if (this.implicitConversion.hasConverter(right, left.getClass())) {
                    return this.implicitConversion.convert(right, left.getClass()).equals(left) == this.equal;
                }
                if (this.implicitConversion.hasConverter(left, right.getClass())) {
                    return this.implicitConversion.convert(left, right.getClass()).equals(right) == this.equal;
                }
                return left.equals(right) == this.equal;
            }
            catch (Exception e) {
                logger.info("Error on comparing " + left + " with " + right, (Throwable)e);
                return false;
            }
        });
    }
}

