/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.opel.BinaryOperationExpressionNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

class SumOperatorExpressionNode
extends BinaryOperationExpressionNode {
    private final ImplicitConversion implicitConversion;

    public SumOperatorExpressionNode(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        super(left, right);
        this.implicitConversion = implicitConversion;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return this.left().getValue(context).thenCombine(this.right().getValue(context), (left, right) -> {
            if (left == null) {
                return this.nullPlus(right);
            }
            if (right == null) {
                return this.nullPlus(left);
            }
            if (left instanceof BigDecimal && right instanceof BigDecimal) {
                return this.sumNumbers((BigDecimal)left, (BigDecimal)right);
            }
            if (left instanceof String && right instanceof String) {
                return this.sumStrings((String)left, (String)right);
            }
            if (left instanceof BigDecimal && this.implicitConversion.hasConverter(right, BigDecimal.class)) {
                return this.sumNumbers((BigDecimal)left, this.implicitConversion.convert(right, BigDecimal.class));
            }
            if (left instanceof String && this.implicitConversion.hasConverter(right, String.class)) {
                return this.sumStrings((String)left, this.implicitConversion.convert(right, String.class));
            }
            if (right instanceof BigDecimal && this.implicitConversion.hasConverter(left, BigDecimal.class)) {
                return this.sumNumbers(this.implicitConversion.convert(left, BigDecimal.class), (BigDecimal)right);
            }
            if (right instanceof String && this.implicitConversion.hasConverter(left, String.class)) {
                return this.sumStrings(this.implicitConversion.convert(left, String.class), (String)right);
            }
            if (this.implicitConversion.hasConverter(left, BigDecimal.class) && this.implicitConversion.hasConverter(right, BigDecimal.class)) {
                return this.sumNumbers(this.implicitConversion.convert(left, BigDecimal.class), this.implicitConversion.convert(right, BigDecimal.class));
            }
            if (this.implicitConversion.hasConverter(left, String.class) && this.implicitConversion.hasConverter(right, String.class)) {
                return this.sumStrings(this.implicitConversion.convert(left, String.class), this.implicitConversion.convert(right, String.class));
            }
            throw new OpelException("Can't sum " + left.getClass().getSimpleName() + " with " + right.getClass().getSimpleName());
        });
    }

    private Object nullPlus(Object node) {
        if (node == null) {
            return BigDecimal.ZERO;
        }
        if (node instanceof BigDecimal || node instanceof String) {
            return node;
        }
        if (this.implicitConversion.hasConverter(node, BigDecimal.class)) {
            return this.implicitConversion.convert(node, BigDecimal.class);
        }
        if (this.implicitConversion.hasConverter(node, String.class)) {
            return this.implicitConversion.convert(node, String.class);
        }
        throw new OpelException("Can't sum null with " + node.getClass().getSimpleName());
    }

    private BigDecimal sumNumbers(BigDecimal left, BigDecimal right) {
        return left.add(right);
    }

    private String sumStrings(String left, String right) {
        return left + right;
    }
}

