/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.OpelNode;

class ArgumentsListExpressionNode
implements OpelNode {
    private final List<OpelNode> args;

    ArgumentsListExpressionNode(List<OpelNode> args) {
        this.args = args;
    }

    List<CompletableFuture<?>> getListOfValues(EvalContext context) {
        return this.args.stream().map(it -> it.getValue(context)).collect(Collectors.toList());
    }

    List<OpelNode> getArgs() {
        return this.args;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        throw new UnsupportedOperationException("Can't get value on ArgumentsListExpressionNode");
    }

    static ArgumentsListExpressionNode empty() {
        return new ArgumentsListExpressionNode(Collections.emptyList());
    }
}

