/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.opel.ArgsGroupNode;
import pl.allegro.tech.opel.ArgumentsListExpressionNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.OpelAsyncFunction;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

public class FunctionChainExpressionNode
implements OpelNode {
    private final OpelNode expression;
    private final ArgsGroupNode argsGroups;

    public FunctionChainExpressionNode(OpelNode expression, ArgsGroupNode argsGroups) {
        this.expression = expression;
        this.argsGroups = argsGroups;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        CompletableFuture<Object> result = this.expression.getValue(context);
        for (ArgumentsListExpressionNode argsGroup : this.argsGroups.getGroups()) {
            result = this.callFunction(result, argsGroup, context);
        }
        return result;
    }

    private CompletableFuture<Object> callFunction(CompletableFuture<?> function, ArgumentsListExpressionNode argsGroup, EvalContext context) {
        return function.thenCompose(fun -> {
            if (fun instanceof OpelAsyncFunction) {
                return ((OpelAsyncFunction)fun).apply(argsGroup.getListOfValues(context));
            }
            throw new OpelException("Can't use '" + fun.getClass().getSimpleName() + "' as a function");
        });
    }
}

