/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.function.Function;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import pl.allegro.tech.opel.OpelException;

class ImplicitConversionUnit<T, R> {
    private final Class<T> from;
    private final Class<R> to;
    private final Function<T, R> convert;

    public ImplicitConversionUnit(Class<T> from, Class<R> to, Function<T, R> convert) {
        this.from = from;
        this.to = to;
        this.convert = convert;
    }

    R convert(Object object) {
        if (ClassUtils.isAssignable(object.getClass(), this.from)) {
            return this.convert.apply(object);
        }
        throw new OpelException("Can't convert '" + object.getClass().getSimpleName() + "', expected '" + this.from.getSimpleName() + "'");
    }

    boolean isApplicable(Class<?> givenType, Class<?> expectedType) {
        return ClassUtils.isAssignable(givenType, this.from) && ClassUtils.isAssignable(expectedType, this.to);
    }

    Class<T> getFrom() {
        return this.from;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitConversionUnit that = (ImplicitConversionUnit)o;
        return new EqualsBuilder().append(this.from, that.from).append(this.to, that.to).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.from).append(this.to).toHashCode();
    }
}

