/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

class NegationOperatorExpressionNode
implements OpelNode {
    private final OpelNode value;
    private final ImplicitConversion implicitConversion;

    public NegationOperatorExpressionNode(OpelNode value, ImplicitConversion implicitConversion) {
        this.value = value;
        this.implicitConversion = implicitConversion;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return this.value.getValue(context).thenApply(it -> {
            if (it == null) {
                return BigDecimal.ZERO;
            }
            if (it instanceof BigDecimal) {
                return ((BigDecimal)it).negate();
            }
            if (this.implicitConversion.hasConverter(it, BigDecimal.class)) {
                return this.implicitConversion.convert(it, BigDecimal.class).negate();
            }
            throw new OpelException("Can negate only number, given " + it.getClass().getSimpleName());
        });
    }
}

