/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collector;
import org.parboiled.Parboiled;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.EvalContextBuilder;
import pl.allegro.tech.opel.ExpressionValidationResult;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.MethodExecutionFilter;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;
import pl.allegro.tech.opel.OpelParser;
import pl.allegro.tech.opel.OpelParsingResult;

public class OpelEngine {
    private final ThreadLocal<OpelParser> parser;
    private final ImplicitConversion implicitConversion;
    private final EvalContext embeddedEvalContext;

    OpelEngine(MethodExecutionFilter methodExecutionFilter, ImplicitConversion implicitConversion, EvalContext embeddedEvalContext) {
        this.embeddedEvalContext = embeddedEvalContext;
        this.implicitConversion = implicitConversion;
        this.parser = ThreadLocal.withInitial(() -> (OpelParser)Parboiled.createParser(OpelParser.class, (Object[])new Object[]{methodExecutionFilter, this.implicitConversion}));
    }

    public ExpressionValidationResult validate(String expression) {
        ParsingResult<OpelNode> parsingResult = this.getParsingResult(expression);
        if (parsingResult.hasErrors()) {
            return ExpressionValidationResult.invalid(parsingResult.parseErrors);
        }
        return ExpressionValidationResult.valid();
    }

    public OpelParsingResult parse(String expression) {
        return new OpelParsingResult(expression, this.getParsingResult(expression), this.embeddedEvalContext);
    }

    public CompletableFuture<?> eval(String expression) {
        ParsingResult<OpelNode> parsingResult = this.getParsingResult(expression);
        if (parsingResult.hasErrors()) {
            throw new OpelException("Error parsing expression: '" + expression + "'" + this.additionalErrorMsg(parsingResult));
        }
        return ((OpelNode)parsingResult.resultValue).getValue(this.embeddedEvalContext);
    }

    private String additionalErrorMsg(ParsingResult<OpelNode> parsingResult) {
        StringJoiner stringJoiner = new StringJoiner(";", " because of ", "");
        stringJoiner.setEmptyValue("");
        Collector<CharSequence, StringJoiner, String> joinerCollector = Collector.of(() -> stringJoiner, StringJoiner::add, StringJoiner::merge, StringJoiner::toString, new Collector.Characteristics[0]);
        return parsingResult.parseErrors.stream().map(ErrorUtils::printParseError).filter(it -> it != null).collect(joinerCollector);
    }

    public CompletableFuture<?> eval(String expression, EvalContext evalContext) {
        ParsingResult<OpelNode> parsingResult = this.getParsingResult(expression);
        return ((OpelNode)parsingResult.resultValue).getValue(EvalContextBuilder.mergeContexts(evalContext, this.embeddedEvalContext));
    }

    private ParsingResult<OpelNode> getParsingResult(String expression) {
        return new ReportingParseRunner(this.parser.get().ParsingUnit()).run(expression);
    }
}

