/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.EvalContextBuilder;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.ImplicitConversionUnit;
import pl.allegro.tech.opel.MethodExecutionFilter;
import pl.allegro.tech.opel.MethodExecutionFilters;
import pl.allegro.tech.opel.OpelAsyncFunction;
import pl.allegro.tech.opel.OpelEngine;

public class OpelEngineBuilder {
    private final Map<String, CompletableFuture<?>> embeddedValues = new HashMap();
    private MethodExecutionFilter methodExecutionFilter = MethodExecutionFilters.ALLOW_ALL;
    private final ImplicitConversion implicitConversion = new ImplicitConversion();

    private OpelEngineBuilder() {
        this.implicitConversion.registerNumberConversion();
    }

    public static OpelEngineBuilder create() {
        return new OpelEngineBuilder();
    }

    @Deprecated
    public OpelEngineBuilder withFunction(String functionName, OpelAsyncFunction<?> function) {
        return this.withCompletedValue(functionName, function);
    }

    @Deprecated
    public OpelEngineBuilder withFunctions(Map<String, OpelAsyncFunction<?>> functions) {
        functions.forEach((name, function) -> this.withCompletedValue((String)name, function));
        return this;
    }

    public OpelEngineBuilder withValue(String valueName, CompletableFuture<Object> value) {
        this.embeddedValues.put(valueName, value);
        return this;
    }

    public OpelEngineBuilder withValues(Map<String, CompletableFuture<?>> values) {
        this.embeddedValues.putAll(values);
        return this;
    }

    public OpelEngineBuilder withCompletedValue(String valueName, Object value) {
        this.embeddedValues.put(valueName, CompletableFuture.completedFuture(value));
        return this;
    }

    public OpelEngineBuilder withMethodExecutionFilter(MethodExecutionFilter methodExecutionFilter) {
        this.methodExecutionFilter = methodExecutionFilter;
        return this;
    }

    public <T, R> OpelEngineBuilder withImplicitConversion(Class<T> from, Class<R> to, Function<T, R> conversion) {
        this.implicitConversion.register(new ImplicitConversionUnit<T, R>(from, to, conversion));
        return this;
    }

    public OpelEngine build() {
        EvalContext context = EvalContextBuilder.create().withValues(this.embeddedValues).build();
        return new OpelEngine(this.methodExecutionFilter, this.implicitConversion, context);
    }
}

