/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.math.BigDecimal;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.annotations.BuildParseTree;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.SuppressSubnodes;
import pl.allegro.tech.opel.IdentifierExpressionNode;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.MethodExecutionFilter;
import pl.allegro.tech.opel.OpelNode;
import pl.allegro.tech.opel.OpelNodeFactory;
import pl.allegro.tech.opel.Operator;

@BuildParseTree
public class OpelParser
extends BaseParser<OpelNode> {
    final ImplicitConversion implicitConversion;
    final OpelNodeFactory nodeFactory;

    OpelParser(MethodExecutionFilter methodExecutionFilter, ImplicitConversion implicitConversion) {
        this.nodeFactory = new OpelNodeFactory(implicitConversion, methodExecutionFilter);
        this.implicitConversion = implicitConversion;
    }

    Rule ParsingUnit() {
        return this.Sequence(this.WhiteSpace(), this.Program(), new Object[]{EOI});
    }

    Rule Program() {
        return this.Body();
    }

    Rule Body() {
        return this.Sequence(this.Declarations(), this.Expression(), new Object[]{this.Optional("; "), this.push(this.nodeFactory.program((OpelNode)this.pop(1), (OpelNode)this.pop()))});
    }

    Rule Factor() {
        return this.FirstOf(this.ifExpression(), this.Sequence(this.Object(), this.Train(), new Object[0]), new Object[]{this.Number(), this.NegativeNumber()});
    }

    Rule Object() {
        return this.FirstOf(this.FunctionCallChain(), this.StringLiteral(), new Object[]{this.FunctionInstantiation(), this.NamedValue(), this.ListInstantiation(), this.MapInstantiation(), this.Sequence("( ", this.Expression(), new Object[]{") "})});
    }

    Rule Train() {
        return this.ZeroOrMore(this.FirstOf(this.MethodCall(), this.FieldAccess(), new Object[0]));
    }

    Rule ifExpression() {
        return this.Sequence("if ", "( ", new Object[]{this.Expression(), ") ", this.Expression(), "else ", this.Expression(), this.push(this.nodeFactory.ifNode((OpelNode)this.pop(2), (OpelNode)this.pop(1), (OpelNode)this.pop()))});
    }

    Rule NamedValue() {
        return this.Sequence(this.Identifier(), this.push(this.namedValueNode((OpelNode)this.pop())), new Object[0]);
    }

    Rule MethodCall() {
        return this.Sequence(". ", this.Identifier(), new Object[]{"( ", this.Args(), ") ", this.push(this.nodeFactory.methodCall((OpelNode)this.pop(2), (OpelNode)this.pop(1), (OpelNode)this.pop()))});
    }

    Rule FieldAccess() {
        return this.FirstOf(this.Sequence("[ ", this.Expression(), new Object[]{"] ", this.push(this.nodeFactory.mapAccess((OpelNode)this.pop(1), (OpelNode)this.pop()))}), this.Sequence(". ", this.Identifier(), new Object[]{this.push(this.nodeFactory.fieldAccess((OpelNode)this.pop(1), (OpelNode)this.pop()))}), new Object[0]);
    }

    Rule StringLiteral() {
        return this.Sequence("'", this.StringContent(), new Object[]{"'", this.push((OpelNode)this.pop()), this.WhiteSpace()});
    }

    Rule StringContent() {
        return this.Sequence(this.ZeroOrMore(this.Sequence(this.TestNot(this.AnyOf("\r\n'")), this.FirstOf(this.escapedChar(), ANY, new Object[0]), new Object[0])), this.push(this.nodeFactory.literalNode(this.escapeString(this.matchOrDefault("")))), new Object[0]);
    }

    Rule escapedChar() {
        return this.Sequence("\\", ANY, new Object[0]);
    }

    Rule FunctionCallChain() {
        return this.Sequence(this.FunctionCall(), this.ArgsGroups(), new Object[]{this.push(this.nodeFactory.functionChain((OpelNode)this.pop(1), (OpelNode)this.pop()))});
    }

    Rule ArgsGroups() {
        return this.Sequence(this.push(this.nodeFactory.emptyArgsGroup()), this.ZeroOrMore(this.ArgsGroup(), EMPTY, new Object[0]), new Object[0]);
    }

    Rule ArgsGroup() {
        return this.Sequence("( ", this.Args(), new Object[]{") ", this.push(this.nodeFactory.argsGroup((OpelNode)this.pop(1), (OpelNode)this.pop()))});
    }

    Rule FunctionCall() {
        return this.FirstOf(this.Sequence(this.Identifier(), "( ", new Object[]{this.Args(), ") ", this.push(this.nodeFactory.functionCallNode((OpelNode)this.pop(1), (OpelNode)this.pop()))}), this.Sequence(this.FunctionInstantiation(), "( ", new Object[]{this.Args(), ") ", this.push(this.nodeFactory.anonymousFunctionCallNode((OpelNode)this.pop(1), (OpelNode)this.pop()))}), new Object[]{this.Sequence("( ", this.Expression(), new Object[]{") ", "( ", this.Args(), ") ", this.push(this.nodeFactory.functionChain((OpelNode)this.pop(1), this.nodeFactory.argsGroup((OpelNode)this.pop())))})});
    }

    Rule Args() {
        return this.Sequence(this.push(this.nodeFactory.emptyArgumentsList()), this.FirstOf(this.Sequence(this.Arg(), this.ZeroOrMore(", ", this.Arg(), new Object[0]), new Object[0]), EMPTY, new Object[0]), new Object[0]);
    }

    Rule Arg() {
        return this.Sequence(this.Expression(), this.push(this.nodeFactory.argumentsList((OpelNode)this.pop(1), (OpelNode)this.pop())), new Object[0]);
    }

    Rule Identifier() {
        return this.Sequence(this.Sequence(this.OneOrMore(this.Letter(), this.ZeroOrMore(this.FirstOf(this.Letter(), this.Digit(), new Object[0])), new Object[0]), this.WhiteSpace(), new Object[0]), this.push(this.nodeFactory.identifierNode(this.match().trim())), new Object[0]);
    }

    Rule AdditiveExpression() {
        return this.Sequence(this.MultiplyExpression(), this.ZeroOrMore(this.FirstOf(this.Sequence("+ ", this.MultiplyExpression(), new Object[]{this.push(this.binaryOperation(Operator.PLUS))}), this.Sequence("- ", this.MultiplyExpression(), new Object[]{this.push(this.binaryOperation(Operator.MINUS))}), new Object[0])), new Object[0]);
    }

    Rule MultiplyExpression() {
        return this.Sequence(this.LogicalNegation(), this.ZeroOrMore(this.FirstOf(this.Sequence("* ", this.LogicalNegation(), new Object[]{this.push(this.binaryOperation(Operator.MULTIPLY))}), this.Sequence("/ ", this.LogicalNegation(), new Object[]{this.push(this.binaryOperation(Operator.DIV))}), new Object[0])), new Object[0]);
    }

    Rule LogicalNegation() {
        return this.FirstOf(this.Sequence("! ", this.LogicalNegation(), new Object[]{this.push(this.nodeFactory.logicalNegationOperatorExpressionNode((OpelNode)this.pop()))}), this.Factor(), new Object[0]);
    }

    Rule Declarations() {
        return this.Sequence(this.push(this.nodeFactory.emptyDeclarationsList()), this.ZeroOrMore(this.Declaration()), new Object[0]);
    }

    Rule Declaration() {
        return this.Sequence("val ", this.Identifier(), new Object[]{"= ", this.Expression(), "; ", this.push(this.nodeFactory.declarationsList((OpelNode)this.pop(2), (OpelNode)this.pop(1), (OpelNode)this.pop()))});
    }

    Rule Expression() {
        return this.OrExpression();
    }

    Rule OrExpression() {
        return this.Sequence(this.AndExpression(), this.ZeroOrMore(this.Sequence("|| ", this.AndExpression(), new Object[]{this.push(this.binaryOperation(Operator.OR))})), new Object[0]);
    }

    Rule AndExpression() {
        return this.Sequence(this.EqualityExpression(), this.ZeroOrMore(this.Sequence("&& ", this.EqualityExpression(), new Object[]{this.push(this.binaryOperation(Operator.AND))})), new Object[0]);
    }

    Rule EqualityExpression() {
        return this.Sequence(this.RelationalExpression(), this.ZeroOrMore(this.FirstOf(this.Sequence("== ", this.RelationalExpression(), new Object[]{this.push(this.binaryOperation(Operator.EQUAL))}), this.Sequence("!= ", this.RelationalExpression(), new Object[]{this.push(this.binaryOperation(Operator.NOT_EQUAL))}), new Object[0])), new Object[0]);
    }

    Rule RelationalExpression() {
        return this.Sequence(this.AdditiveExpression(), this.ZeroOrMore(this.FirstOf(this.Sequence("> ", this.AdditiveExpression(), new Object[]{this.push(this.binaryOperation(Operator.GT))}), this.Sequence(">= ", this.AdditiveExpression(), new Object[]{this.push(this.binaryOperation(Operator.GTE))}), new Object[]{this.Sequence("< ", this.AdditiveExpression(), new Object[]{this.push(this.binaryOperation(Operator.LT))}), this.Sequence("<= ", this.AdditiveExpression(), new Object[]{this.push(this.binaryOperation(Operator.LTE))})})), new Object[0]);
    }

    Rule NegativeNumber() {
        return this.Sequence(this.AnyOf("-"), this.Factor(), new Object[]{this.push(this.nodeFactory.negationNode((OpelNode)this.pop())), this.WhiteSpace()});
    }

    Rule Number() {
        return this.FirstOf(this.DecimalNumber(), this.IntNumber(), new Object[0]);
    }

    Rule DecimalNumber() {
        return this.Sequence(this.Sequence(this.Digits(), ".", new Object[]{this.Digits()}), this.push(this.nodeFactory.literalNode(new BigDecimal(this.match()))), new Object[]{this.WhiteSpace()});
    }

    Rule IntNumber() {
        return this.Sequence(this.Digits(), this.push(this.nodeFactory.literalNode(BigDecimal.valueOf(Integer.parseInt(this.matchOrDefault("0"))))), new Object[]{this.WhiteSpace()});
    }

    Rule FunctionInstantiation() {
        return this.Sequence(this.FunctionArgs(), "-> ", new Object[]{this.FunctionBody(), this.push(this.nodeFactory.functionInstantiation((OpelNode)this.pop(1), (OpelNode)this.pop()))});
    }

    Rule FunctionArgs() {
        return this.FirstOf(this.Sequence("( ", this.IdentifiersList(), new Object[]{") "}), this.Sequence(this.push(this.nodeFactory.emptyIdentifiersList()), this.IdentifiersListItem(), new Object[0]), new Object[0]);
    }

    Rule IdentifiersList() {
        return this.Sequence(this.push(this.nodeFactory.emptyIdentifiersList()), this.FirstOf(this.Sequence(this.IdentifiersListItem(), this.ZeroOrMore(", ", this.IdentifiersListItem(), new Object[0]), new Object[0]), EMPTY, new Object[0]), new Object[0]);
    }

    Rule IdentifiersListItem() {
        return this.Sequence(this.Identifier(), this.push(this.nodeFactory.identifiersList((OpelNode)this.pop(1), (OpelNode)this.pop())), new Object[0]);
    }

    Rule FunctionBody() {
        return this.FirstOf(this.Expression(), this.Sequence("{ ", this.Body(), new Object[]{"} "}), new Object[0]);
    }

    Rule ListInstantiation() {
        return this.Sequence("[ ", this.Args(), new Object[]{"] ", this.push(this.nodeFactory.listInstantiation((OpelNode)this.pop()))});
    }

    Rule MapInstantiation() {
        return this.Sequence("{ ", this.Pairs(), new Object[]{"} ", this.push(this.nodeFactory.mapInstantiationExpressionNode((OpelNode)this.pop()))});
    }

    Rule Pairs() {
        return this.Sequence(this.push(this.nodeFactory.emptyPairsListNode()), this.FirstOf(this.Sequence(this.Pair(), this.ZeroOrMore(", ", this.Pair(), new Object[0]), new Object[0]), ": ", new Object[0]), new Object[0]);
    }

    Rule Pair() {
        return this.Sequence(this.Factor(), ": ", new Object[]{this.Expression(), this.push(this.nodeFactory.pairs((OpelNode)this.pop(2), (OpelNode)this.pop(1), (OpelNode)this.pop()))});
    }

    @SuppressSubnodes
    Rule Digits() {
        return this.OneOrMore(this.Digit());
    }

    Rule Digit() {
        return this.CharRange('0', '9');
    }

    Rule Letter() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{Character.valueOf('_'), Character.valueOf('$')});
    }

    Rule WhiteSpace() {
        return this.ZeroOrMore(this.AnyOf(" \t\n"));
    }

    @DontLabel
    protected Rule fromStringLiteral(String string) {
        if (string.endsWith(" ")) {
            String substring = string.substring(0, string.length() - 1);
            return this.Sequence(this.String(substring), this.WhiteSpace(), new Object[0]).label("'" + substring + "'");
        }
        return this.String(string).label("'" + string + "'");
    }

    protected String escapeString(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                ++i;
            }
            result.append(string.charAt(i));
        }
        return result.toString();
    }

    protected OpelNode binaryOperation(Operator operator) {
        return this.nodeFactory.binaryOperationNode(operator, (OpelNode)this.pop(1), (OpelNode)this.pop());
    }

    protected OpelNode namedValueNode(OpelNode valueIdentifierNode) {
        if (valueIdentifierNode instanceof IdentifierExpressionNode) {
            String identifier;
            switch (identifier = ((IdentifierExpressionNode)valueIdentifierNode).getIdentifier()) {
                case "true": {
                    return this.nodeFactory.literalNode(true);
                }
                case "false": {
                    return this.nodeFactory.literalNode(false);
                }
                case "null": {
                    return this.nodeFactory.literalNode(null);
                }
            }
        }
        return this.nodeFactory.namedValueNode(valueIdentifierNode);
    }
}

