/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.ParseError;
import org.parboiled.support.ParsingResult;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.EvalContextBuilder;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

public class OpelParsingResult {
    private final ParsingResult<OpelNode> parsingResult;
    private final String expression;
    private final EvalContext embeddedEvalContext;

    OpelParsingResult(String expression, ParsingResult<OpelNode> parsingResult, EvalContext embeddedEvalContext) {
        this.parsingResult = parsingResult;
        this.expression = expression;
        this.embeddedEvalContext = embeddedEvalContext;
    }

    public CompletableFuture<?> eval(EvalContext context) {
        return this.evalWithFinalContext(EvalContextBuilder.mergeContexts(context, this.embeddedEvalContext));
    }

    public CompletableFuture<?> eval() {
        return this.evalWithFinalContext(this.embeddedEvalContext);
    }

    private CompletableFuture<?> evalWithFinalContext(EvalContext context) {
        return this.getParsedExpression().map(node -> node.getValue(context)).orElseThrow(() -> new OpelException("Expression '" + this.expression + "' contain's syntax error " + ErrorUtils.printParseErrors(this.parsingResult)));
    }

    private Optional<OpelNode> getParsedExpression() {
        if (this.parsingResult.hasErrors()) {
            return Optional.empty();
        }
        return Optional.of((OpelNode)this.parsingResult.resultValue);
    }

    public boolean isValid() {
        return !this.parsingResult.hasErrors();
    }

    public List<ParseError> getErrors() {
        return this.parsingResult.parseErrors;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getParsingErrorMessage() {
        return ErrorUtils.printParseErrors((List)this.parsingResult.parseErrors);
    }
}

