/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import pl.allegro.tech.opel.BinaryOperationExpressionNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

class IfExpressionNode
extends BinaryOperationExpressionNode {
    private final OpelNode condition;
    private final ImplicitConversion implicitConversion;

    public IfExpressionNode(OpelNode condition, OpelNode trueValue, OpelNode falseValue, ImplicitConversion implicitConversion) {
        super(trueValue, falseValue);
        this.condition = condition;
        this.implicitConversion = implicitConversion;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return this.condition.getValue(context).thenCompose(conditionValue -> this.calculateExpression(conditionValue, context));
    }

    private CompletableFuture<?> calculateExpression(Object truthValue, EvalContext context) {
        if (truthValue == null) {
            return this.right().getValue(context);
        }
        if (truthValue instanceof Boolean) {
            return this.decision((Boolean)truthValue, () -> this.left().getValue(context), () -> this.right().getValue(context));
        }
        if (this.implicitConversion.hasConverter(truthValue, Boolean.class)) {
            return this.decision(this.implicitConversion.convert(truthValue, Boolean.class), () -> this.left().getValue(context), () -> this.right().getValue(context));
        }
        throw new OpelException("'" + truthValue.getClass().getSimpleName() + "' can't be use as if expression argument.");
    }

    private CompletableFuture<?> decision(Boolean truthValue, Supplier<CompletableFuture<?>> left, Supplier<CompletableFuture<?>> right) {
        if (truthValue.booleanValue()) {
            return left.get();
        }
        return right.get();
    }
}

