/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import pl.allegro.tech.opel.ImplicitConversionUnit;

class ImplicitConversion {
    private final Set<ImplicitConversionUnit<?, ?>> implicitConversionUnits;

    public ImplicitConversion() {
        this(new HashSet());
    }

    ImplicitConversion(Set<ImplicitConversionUnit<?, ?>> implicitConversionUnits) {
        this.implicitConversionUnits = implicitConversionUnits;
    }

    public void register(ImplicitConversionUnit<?, ?> conversionUnit) {
        this.implicitConversionUnits.add(conversionUnit);
    }

    void registerNumberConversion() {
        this.implicitConversionUnits.addAll(ImplicitConversion.numberToBigDecimalConversion());
    }

    public <R> R convert(Object object, Class<R> expectedType) {
        if (object == null || ClassUtils.isAssignable(object.getClass(), expectedType)) {
            return (R)object;
        }
        Class<?> givenType = object.getClass();
        return (R)this.implicitConversionUnits.stream().filter(conversionUnit -> conversionUnit.isApplicable(givenType, expectedType)).findFirst().map(it -> it.convert(object)).orElseThrow(() -> new RuntimeException("Can't convert " + object.getClass().getSimpleName() + " to " + expectedType.getSimpleName()));
    }

    public <R> boolean hasConverter(Object object, Class<R> expectedType) {
        if (object == null) {
            return false;
        }
        if (ClassUtils.isAssignable(object.getClass(), expectedType)) {
            return true;
        }
        Class<?> givenType = object.getClass();
        return this.implicitConversionUnits.stream().filter(conversionUnit -> conversionUnit.isApplicable(givenType, expectedType)).findFirst().isPresent();
    }

    public Stream<Object> getAllPossibleConversions(Object object) {
        Stream<Object> identity = Stream.of(object);
        Stream<Object> convertedValues = this.implicitConversionUnits.stream().filter(unit -> unit.getFrom() == object.getClass()).map(unit -> this.succeedConversion((ImplicitConversionUnit<?, ?>)unit, object)).filter(Optional::isPresent).map(Optional::get);
        return Stream.concat(identity, convertedValues);
    }

    private Optional<Object> succeedConversion(ImplicitConversionUnit<?, ?> unit, Object objectToConvert) {
        try {
            return Optional.ofNullable(unit.convert(objectToConvert));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Set<ImplicitConversionUnit<?, ?>> numberToBigDecimalConversion() {
        HashSet implicitConversionUnits = new HashSet();
        implicitConversionUnits.add(new ImplicitConversionUnit<Long, BigDecimal>(Long.class, BigDecimal.class, BigDecimal::valueOf));
        implicitConversionUnits.add(new ImplicitConversionUnit<BigDecimal, Long>(BigDecimal.class, Long.class, BigDecimal::longValueExact));
        implicitConversionUnits.add(new ImplicitConversionUnit<Integer, BigDecimal>(Integer.class, BigDecimal.class, BigDecimal::valueOf));
        implicitConversionUnits.add(new ImplicitConversionUnit<BigDecimal, Integer>(BigDecimal.class, Integer.class, BigDecimal::intValueExact));
        implicitConversionUnits.add(new ImplicitConversionUnit<Short, BigDecimal>(Short.class, BigDecimal.class, BigDecimal::valueOf));
        implicitConversionUnits.add(new ImplicitConversionUnit<BigDecimal, Short>(BigDecimal.class, Short.class, BigDecimal::shortValueExact));
        implicitConversionUnits.add(new ImplicitConversionUnit<Byte, BigDecimal>(Byte.class, BigDecimal.class, BigDecimal::valueOf));
        implicitConversionUnits.add(new ImplicitConversionUnit<BigDecimal, Byte>(BigDecimal.class, Byte.class, BigDecimal::byteValueExact));
        implicitConversionUnits.add(new ImplicitConversionUnit<Double, BigDecimal>(Double.class, BigDecimal.class, BigDecimal::valueOf));
        implicitConversionUnits.add(new ImplicitConversionUnit<BigDecimal, Double>(BigDecimal.class, Double.class, BigDecimal::doubleValue));
        implicitConversionUnits.add(new ImplicitConversionUnit<Float, BigDecimal>(Float.class, BigDecimal.class, BigDecimal::valueOf));
        implicitConversionUnits.add(new ImplicitConversionUnit<BigDecimal, Float>(BigDecimal.class, Float.class, BigDecimal::floatValue));
        return implicitConversionUnits;
    }
}

