/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

class LogicalNegationOperatorExpressionNode
implements OpelNode {
    private final OpelNode opelNode;
    private final ImplicitConversion conversion;

    LogicalNegationOperatorExpressionNode(OpelNode opelNode, ImplicitConversion conversion) {
        this.opelNode = opelNode;
        this.conversion = conversion;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return this.opelNode.getValue(context).thenApply(this::getValue);
    }

    private Boolean getValue(Object value) {
        if (value == null) {
            throw new OpelException("Can't negate null value");
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (this.conversion.hasConverter(value, Boolean.class)) {
            return this.conversion.convert(value, Boolean.class) == false;
        }
        throw new OpelException("Can't negate " + value.getClass().getSimpleName() + " type");
    }
}

